/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.nodemanager.service;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import won.matcher.service.common.service.sparql.SparqlService;
import won.protocol.exception.DataIntegrityException;
import won.protocol.service.WonNodeInfo;
import won.protocol.util.WonRdfUtils;
import won.protocol.vocabulary.WON;

@Component
public class WonNodeSparqlService
extends SparqlService {
    @Autowired
    public WonNodeSparqlService(@Value(value="${uri.sparql.endpoint}") String sparqlEndpoint) {
        super(sparqlEndpoint);
    }

    public Set<WonNodeInfo> retrieveAllWonNodeInfo() {
        HashSet<WonNodeInfo> wonNodeInfos = new HashSet<WonNodeInfo>();
        String queryString = "SELECT ?graphUri ?nodeUri WHERE { GRAPH ?graphUri {?nodeUri won:hasUriPrefixSpecification ?c} }";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setCommandText(queryString);
        pps.setNsPrefix("won", "http://purl.org/webofneeds/model#");
        this.log.debug("Query SPARQL Endpoint: {}", (Object)this.sparqlEndpoint);
        this.log.debug("Execute query: {}", (Object)pps.toString());
        QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());
        ResultSet results = qexec.execSelect();
        while (results.hasNext()) {
            QuerySolution qs = results.nextSolution();
            RDFNode rdfNode = qs.get("graphUri");
            if (rdfNode == null) continue;
            String graphUri = rdfNode.asResource().getURI();
            Dataset ds = this.retrieveDataset(graphUri);
            WonNodeInfo nodeInfo = this.getWonNodeInfoFromDataset(ds);
            wonNodeInfos.add(nodeInfo);
        }
        qexec.close();
        return wonNodeInfos;
    }

    public WonNodeInfo getWonNodeInfoFromDataset(Dataset ds) {
        String dsWonNodeUri = this.getWonNodeUriFromDataset(ds);
        WonNodeInfo nodeInfo = WonRdfUtils.WonNodeUtils.getWonNodeInfo((URI)URI.create(dsWonNodeUri), (Dataset)ds);
        if (nodeInfo == null) {
            throw new DataIntegrityException("Could not load won node info from dataset with URI: " + dsWonNodeUri);
        }
        return nodeInfo;
    }

    private String getWonNodeUriFromDataset(Dataset ds) {
        Model model;
        if (ds.listNames().hasNext() && (model = ds.getNamedModel((String)ds.listNames().next())).listSubjectsWithProperty(WON.HAS_URI_PATTERN_SPECIFICATION).hasNext()) {
            return model.listSubjectsWithProperty(WON.HAS_URI_PATTERN_SPECIFICATION).nextResource().toString();
        }
        return null;
    }
}

