/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.nodemanager.config;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActorContext;
import akka.camel.Camel;
import akka.camel.CamelExtension;
import java.util.UUID;
import javax.jms.ConnectionFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.camel.Component;
import org.apache.camel.component.jms.JmsComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.ssl.MessagingContext;
import won.matcher.service.common.spring.SpringExtension;
import won.matcher.service.nodemanager.actor.HintProducerProtocolActor;
import won.matcher.service.nodemanager.actor.NeedConsumerProtocolActor;
import won.matcher.service.nodemanager.pojo.WonNodeConnection;
import won.protocol.service.WonNodeInfo;
import won.protocol.vocabulary.WON;

public class ActiveMqWonNodeConnectionFactory {
    protected static final Logger log = LoggerFactory.getLogger(ActiveMqWonNodeConnectionFactory.class);

    public static WonNodeConnection createWonNodeConnection(UntypedActorContext context, WonNodeInfo wonNodeInfo, MessagingContext messagingContext) {
        ActorRef deactivated;
        String activeMq = WON.WON_OVER_ACTIVE_MQ.toString();
        String brokerUri = wonNodeInfo.getSupportedProtocolImplParamValue(activeMq, WON.HAS_BROKER_URI.toString());
        String createdTopic = wonNodeInfo.getSupportedProtocolImplParamValue(activeMq, WON.HAS_ACTIVEMQ_MATCHER_PROTOCOL_OUT_NEED_CREATED_TOPIC_NAME.toString());
        String activatedTopic = wonNodeInfo.getSupportedProtocolImplParamValue(activeMq, WON.HAS_ACTIVEMQ_MATCHER_PROTOCOL_OUT_NEED_ACTIVATED_TOPIC_NAME.toString());
        String deactivatedTopic = wonNodeInfo.getSupportedProtocolImplParamValue(activeMq, WON.HAS_ACTIVEMQ_MATCHER_PROTOCOL_OUT_NEED_DEACTIVATED_TOPIC_NAME.toString());
        String hintQueue = wonNodeInfo.getSupportedProtocolImplParamValue(activeMq, WON.HAS_ACTIVEMQ_MATCHER_PROTOCOL_QUEUE_NAME.toString());
        String uuid = UUID.randomUUID().toString();
        String componentName = "activemq-" + uuid;
        ActiveMQConnectionFactory connectionFactory = ActiveMqWonNodeConnectionFactory.createConnectionFactory(brokerUri, messagingContext);
        Camel camel = CamelExtension.get((ActorSystem)context.system());
        camel.context().addComponent(componentName, (Component)JmsComponent.jmsComponent((ConnectionFactory)connectionFactory));
        String createdComponent = componentName + ":topic:" + createdTopic + "?testConnectionOnStartup=false";
        Props createdProps = ((SpringExtension.SpringExt)SpringExtension.SpringExtProvider.get(context.system())).props(NeedConsumerProtocolActor.class, createdComponent);
        ActorRef created = context.actorOf(createdProps, "ActiveMqNeedCreatedConsumerProtocolActor-" + uuid);
        log.info("Create camel component JMS listener {} for won node {}", (Object)createdComponent, (Object)wonNodeInfo.getWonNodeURI());
        ActorRef activated = created;
        if (!activatedTopic.equals(createdTopic)) {
            String activatedComponent = componentName + ":topic:" + activatedTopic + "?testConnectionOnStartup=false";
            Props activatedProps = ((SpringExtension.SpringExt)SpringExtension.SpringExtProvider.get(context.system())).props(NeedConsumerProtocolActor.class, activatedComponent);
            activated = context.actorOf(activatedProps, "ActiveMqNeedActivatedConsumerProtocolActor-" + uuid);
            log.info("Create camel component JMS listener {} for won node {}", (Object)activatedComponent, (Object)wonNodeInfo.getWonNodeURI());
        }
        if (deactivatedTopic.equals(createdTopic)) {
            deactivated = created;
        } else if (deactivatedTopic.equals(activatedTopic)) {
            deactivated = activated;
        } else {
            String deactivatedComponent = componentName + ":topic:" + deactivatedTopic + "?testConnectionOnStartup=false";
            Props deactivatedProps = ((SpringExtension.SpringExt)SpringExtension.SpringExtProvider.get(context.system())).props(NeedConsumerProtocolActor.class, deactivatedComponent);
            deactivated = context.actorOf(deactivatedProps, "ActiveMqNeedDeactivatedConsumerProtocolActor-" + uuid);
            log.info("Create camel component JMS listener {} for won node {}", (Object)deactivatedComponent, (Object)wonNodeInfo.getWonNodeURI());
        }
        String hintComponent = componentName + ":queue:" + hintQueue;
        Props hintProps = ((SpringExtension.SpringExt)SpringExtension.SpringExtProvider.get(context.system())).props(HintProducerProtocolActor.class, hintComponent, null);
        ActorRef hintProducer = context.actorOf(hintProps, "ActiveMqHintProducerProtocolActor-" + uuid);
        log.info("Create camel component JMS listener {} for won node {}", (Object)hintComponent, (Object)wonNodeInfo.getWonNodeURI());
        context.watch(created);
        context.watch(activated);
        context.watch(deactivated);
        context.watch(hintProducer);
        WonNodeConnection jmsConnection = new WonNodeConnection(wonNodeInfo, created, activated, deactivated, hintProducer);
        return jmsConnection;
    }

    private static ActiveMQConnectionFactory createConnectionFactory(String brokerUri, MessagingContext messagingContext) {
        X509KeyManager keyManager = null;
        TrustManager trustManager = null;
        if (messagingContext != null) {
            try {
                keyManager = messagingContext.getClientKeyManager();
                trustManager = messagingContext.getClientTrustManager();
            }
            catch (Exception e) {
                log.error("Key- or Trust- manager initialization problem", (Throwable)e);
            }
        }
        ActiveMQSslConnectionFactory connectionFactory = new ActiveMQSslConnectionFactory(brokerUri + "?jms.prefetchPolicy.all=50");
        connectionFactory.setAlwaysSyncSend(false);
        connectionFactory.setDisableTimeStampsByDefault(true);
        if (keyManager != null && trustManager != null) {
            connectionFactory.setKeyAndTrustManagers(new KeyManager[]{keyManager}, new TrustManager[]{trustManager}, null);
        } else {
            log.warn("key or trust manager was null, therefore do not set them in connection factory");
        }
        return connectionFactory;
    }
}

