/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.nodemanager.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.OneForOneStrategy;
import akka.actor.SupervisorStrategy;
import akka.actor.UntypedActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.japi.Function;
import org.apache.jena.query.Dataset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import scala.concurrent.duration.Duration;
import won.matcher.service.common.event.NeedEvent;
import won.matcher.service.common.service.sparql.SparqlService;

@Component
@Scope(value="prototype")
public class SaveNeedEventActor
extends UntypedActor {
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private ActorRef pubSubMediator;
    @Autowired
    private SparqlService sparqlService;

    public void preStart() {
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Subscribe(NeedEvent.class.getName(), this.getSelf()), this.getSelf());
    }

    public void onReceive(Object o) throws Exception {
        if (o instanceof NeedEvent) {
            NeedEvent needEvent = (NeedEvent)o;
            this.log.debug("Save need event {} to sparql endpoint {}", (Object)needEvent, (Object)this.sparqlService.getSparqlEndpoint());
            Dataset ds = needEvent.deserializeNeedDataset();
            this.sparqlService.updateNamedGraphsOfDataset(ds);
        } else {
            this.unhandled(o);
        }
    }

    public SupervisorStrategy supervisorStrategy() {
        OneForOneStrategy supervisorStrategy = new OneForOneStrategy(0, (Duration)Duration.Zero(), (Function)new Function<Throwable, SupervisorStrategy.Directive>(){

            public SupervisorStrategy.Directive apply(Throwable t) throws Exception {
                SaveNeedEventActor.this.log.warning("Actor encountered error: {}", (Object)t);
                return SupervisorStrategy.escalate();
            }
        });
        return supervisorStrategy;
    }
}

