/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.nodemanager.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.OneForOneStrategy;
import akka.actor.SupervisorStrategy;
import akka.camel.CamelMessage;
import akka.camel.javaapi.UntypedConsumerActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.japi.Function;
import java.net.URI;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import scala.concurrent.duration.Duration;
import won.matcher.service.common.event.NeedEvent;
import won.matcher.service.common.service.monitoring.MonitoringService;
import won.matcher.service.crawler.msg.CrawlUriMessage;
import won.matcher.service.crawler.msg.ResourceCrawlUriMessage;
import won.protocol.util.linkeddata.LinkedDataSource;

@Component
@Scope(value="prototype")
public class NeedConsumerProtocolActor
extends UntypedConsumerActor {
    private static final String MSG_HEADER_METHODNAME = "methodName";
    private static final String MSG_HEADER_METHODNAME_NEEDCREATED = "needCreated";
    private static final String MSG_HEADER_METHODNAME_NEEDACTIVATED = "needActivated";
    private static final String MSG_HEADER_METHODNAME_NEEDDEACTIVATED = "needDeactivated";
    private static final String MSG_HEADER_WON_NODE_URI = "wonNodeURI";
    private static final String MSG_HEADER_NEED_URI = "needURI";
    private final String endpoint;
    private ActorRef pubSubMediator;
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    @Autowired
    private MonitoringService monitoringService;
    @Autowired
    private LinkedDataSource linkedDataSource;

    public NeedConsumerProtocolActor(String endpoint) {
        this.endpoint = endpoint;
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
    }

    public String getEndpointUri() {
        return this.endpoint;
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof CamelMessage) {
            CamelMessage camelMsg = (CamelMessage)message;
            String needUri = (String)camelMsg.getHeaders().get(MSG_HEADER_NEED_URI);
            String wonNodeUri = (String)camelMsg.getHeaders().get(MSG_HEADER_WON_NODE_URI);
            this.monitoringService.startClock("NeedReceivedUntilFirstHintSent", needUri);
            if (needUri != null && wonNodeUri != null) {
                Object methodName = camelMsg.getHeaders().get(MSG_HEADER_METHODNAME);
                if (methodName != null) {
                    this.log.debug("Received event '{}' for needUri '{}' and wonNeedUri '{}' and publish it to matchers", methodName, (Object)needUri, (Object)wonNodeUri);
                    NeedEvent event = null;
                    long crawlDate = System.currentTimeMillis();
                    Dataset ds = this.linkedDataSource.getDataForResource(URI.create(needUri));
                    if (methodName.equals(MSG_HEADER_METHODNAME_NEEDCREATED)) {
                        event = new NeedEvent(needUri, wonNodeUri, NeedEvent.TYPE.ACTIVE, crawlDate, ds);
                        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(event.getClass().getName(), (Object)event), this.getSelf());
                    } else if (methodName.equals(MSG_HEADER_METHODNAME_NEEDACTIVATED)) {
                        event = new NeedEvent(needUri, wonNodeUri, NeedEvent.TYPE.ACTIVE, crawlDate, ds);
                        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(event.getClass().getName(), (Object)event), this.getSelf());
                    } else if (methodName.equals(MSG_HEADER_METHODNAME_NEEDDEACTIVATED)) {
                        event = new NeedEvent(needUri, wonNodeUri, NeedEvent.TYPE.INACTIVE, crawlDate, ds);
                        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(event.getClass().getName(), (Object)event), this.getSelf());
                    } else {
                        this.unhandled(message);
                    }
                    ResourceCrawlUriMessage resMsg = new ResourceCrawlUriMessage(needUri, needUri, wonNodeUri, CrawlUriMessage.STATUS.SAVE, crawlDate, null);
                    resMsg.setSerializedResource(camelMsg.body().toString());
                    resMsg.setSerializationFormat(Lang.TRIG);
                    this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(resMsg.getClass().getName(), (Object)resMsg), this.getSelf());
                    return;
                }
                this.log.warning("Message not processed; methodName is null");
            } else {
                this.log.warning("Message not processed; needURI or wonNodeURI is null");
            }
        }
        this.unhandled(message);
    }

    public SupervisorStrategy supervisorStrategy() {
        OneForOneStrategy supervisorStrategy = new OneForOneStrategy(0, (Duration)Duration.Zero(), (Function)new Function<Throwable, SupervisorStrategy.Directive>(){

            public SupervisorStrategy.Directive apply(Throwable t) throws Exception {
                NeedConsumerProtocolActor.this.log.warning("Actor encountered error: {}", (Object)t);
                return SupervisorStrategy.escalate();
            }
        });
        return supervisorStrategy;
    }
}

