/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.crawler.service;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import won.matcher.service.common.event.BulkNeedEvent;
import won.matcher.service.common.event.NeedEvent;
import won.matcher.service.common.service.sparql.SparqlService;
import won.matcher.service.crawler.config.CrawlConfig;
import won.matcher.service.crawler.msg.CrawlUriMessage;

@Component
public class CrawlSparqlService
extends SparqlService {
    private static final String HTTP_HEADER_SEPARATOR = ", ";
    @Autowired
    private CrawlConfig config;

    @Autowired
    public CrawlSparqlService(@Value(value="${uri.sparql.endpoint}") String sparqlEndpoint) {
        super(sparqlEndpoint);
    }

    public void updateCrawlingMetadata(CrawlUriMessage msg) {
        this.executeUpdateQuery(this.createUpdateCrawlingMetadataQuery(msg));
    }

    public void bulkUpdateCrawlingMetadata(Collection<CrawlUriMessage> msgs) {
        StringBuilder builder = new StringBuilder();
        for (CrawlUriMessage msg : msgs) {
            builder.append(this.createUpdateCrawlingMetadataQuery(msg));
        }
        this.executeUpdateQuery(builder.toString());
    }

    private String createUpdateCrawlingMetadataQuery(CrawlUriMessage msg) {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE WHERE { GRAPH won:crawlMetadata { ?msgUri ?y ?z}};\n");
        builder.append("\nINSERT DATA { GRAPH won:crawlMetadata {\n");
        builder.append("?msgUri won:crawlDate ?crawlDate.\n");
        builder.append("?msgUri won:crawlStatus ?crawlStatus.\n");
        builder.append("?msgUri won:crawlBaseUri ?crawlBaseUri.\n");
        if (msg.getWonNodeUri() != null) {
            builder.append("?msgUri won:wonNodeUri ?wonNodeUri.\n");
        }
        if (msg.getResourceETagHeaderValues() != null && !msg.getResourceETagHeaderValues().isEmpty()) {
            for (int i = 0; i < msg.getResourceETagHeaderValues().size(); ++i) {
                builder.append("?msgUri won:resourceETagValue ? .\n");
            }
        }
        builder.append("}};\n");
        ParameterizedSparqlString pss = new ParameterizedSparqlString();
        pss.setCommandText(builder.toString());
        pss.setNsPrefix("won", "http://purl.org/webofneeds/model#");
        pss.setIri("msgUri", msg.getUri());
        pss.setLiteral("crawlDate", msg.getCrawlDate());
        pss.setLiteral("crawlStatus", msg.getStatus().toString());
        pss.setIri("crawlBaseUri", msg.getBaseUri());
        if (msg.getWonNodeUri() != null) {
            pss.setIri("wonNodeUri", msg.getWonNodeUri());
        }
        if (msg.getResourceETagHeaderValues() != null && !msg.getResourceETagHeaderValues().isEmpty()) {
            int i = 0;
            for (String etagValue : msg.getResourceETagHeaderValues()) {
                pss.setLiteral(i, etagValue);
                ++i;
            }
        }
        return pss.toString();
    }

    private Set<String> commaConcatenatedStringToSet(String contatenatedString) {
        if (contatenatedString == null || contatenatedString.isEmpty()) {
            return null;
        }
        String[] splitValues = StringUtils.split((String)contatenatedString, (String)HTTP_HEADER_SEPARATOR);
        if (splitValues == null) {
            return new HashSet<String>(Arrays.asList(contatenatedString));
        }
        return new HashSet<String>(Arrays.asList(splitValues));
    }

    public Set<CrawlUriMessage> retrieveMessagesForCrawling(CrawlUriMessage.STATUS status) {
        LinkedHashSet<CrawlUriMessage> msgs = new LinkedHashSet<CrawlUriMessage>();
        String queryString = "SELECT ?uri ?base ?wonNode (group_concat(distinct ?etag;separator=\", \") as ?etags) WHERE { GRAPH won:crawlMetadata {\n ?uri ?p ?status.\n ?uri won:crawlBaseUri ?base.\n OPTIONAL { ?uri won:wonNodeUri ?wonNode }\n OPTIONAL { ?uri won:resourceETagValue ?etag }}}\n GROUP BY ?uri ?base ?wonNode\n";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setNsPrefix("won", "http://purl.org/webofneeds/model#");
        pps.setCommandText(queryString);
        pps.setLiteral("status", status.toString());
        this.log.debug("Query SPARQL Endpoint: {}", (Object)this.sparqlEndpoint);
        this.log.debug("Execute query: {}", (Object)pps.toString());
        QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());
        ResultSet results = qexec.execSelect();
        while (results.hasNext()) {
            QuerySolution qs = results.nextSolution();
            String uri = qs.get("uri").asResource().getURI();
            String baseUri = qs.get("base").asResource().getURI();
            CrawlUriMessage msg = null;
            String wonNode = null;
            Set<String> etags = null;
            if (qs.get("wonNode") != null) {
                wonNode = qs.get("wonNode").asResource().getURI();
            }
            if (qs.get("etags") != null) {
                String etagsString = qs.get("etags").asLiteral().getString();
                etags = this.commaConcatenatedStringToSet(etagsString);
            }
            msg = new CrawlUriMessage(uri, baseUri, wonNode, CrawlUriMessage.STATUS.PROCESS, System.currentTimeMillis(), etags);
            this.log.debug("Created message: {}", (Object)msg);
            msgs.add(msg);
        }
        qexec.close();
        return msgs;
    }

    public Set<CrawlUriMessage> extractCrawlUriMessages(String baseUri, String wonNodeUri) {
        Set<CrawlUriMessage> msgs;
        HashSet<CrawlUriMessage> newCrawlMessages = new HashSet<CrawlUriMessage>();
        for (String prop : this.config.getCrawlNonBasePropertyPaths()) {
            msgs = this.extractCrawlUriMessagesForPropertyPath(baseUri, wonNodeUri, prop, false);
            if (msgs == null) continue;
            newCrawlMessages.addAll(msgs);
        }
        for (String prop : this.config.getCrawlBasePropertyPaths()) {
            msgs = this.extractCrawlUriMessagesForPropertyPath(baseUri, wonNodeUri, prop, true);
            if (msgs == null) continue;
            newCrawlMessages.addAll(msgs);
        }
        return newCrawlMessages;
    }

    private Set<CrawlUriMessage> extractCrawlUriMessagesForPropertyPath(String baseUri, String wonNodeUri, String propertyPath, boolean baseProperty) {
        if (propertyPath.trim().length() == 0) {
            return null;
        }
        HashSet<CrawlUriMessage> newCrawlMessages = new HashSet<CrawlUriMessage>();
        long crawlDate = System.currentTimeMillis();
        String queryString = "SELECT ?uri (group_concat(distinct ?etag;separator=\", \") as ?etags) WHERE {\n{ ?baseUriWithTrailingSlash " + propertyPath + " ?uri. } \nUNION { ?baseUriWithoutTrailingSlash " + propertyPath + " ?uri. } \n OPTIONAL {?uri won:resourceETagValue ?etag. }}\n GROUP BY ?uri\n";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setNsPrefix("won", "http://purl.org/webofneeds/model#");
        pps.setCommandText(queryString);
        baseUri = baseUri.trim();
        if (baseUri.endsWith("/")) {
            baseUri = baseUri.substring(0, baseUri.length() - 1);
        }
        pps.setIri("baseUriWithoutTrailingSlash", baseUri);
        pps.setIri("baseUriWithTrailingSlash", baseUri + "/");
        this.log.debug("Query SPARQL Endpoint: {}", (Object)this.sparqlEndpoint);
        this.log.debug("Execute query: {}", (Object)pps.toString());
        QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());
        ResultSet results = qexec.execSelect();
        while (results.hasNext()) {
            QuerySolution qs = results.nextSolution();
            String extractedUri = qs.get("uri").asResource().getURI();
            Set<String> etags = null;
            if (qs.get("etags") != null) {
                String etagsString = qs.get("etags").asLiteral().getString();
                etags = this.commaConcatenatedStringToSet(etagsString);
            }
            CrawlUriMessage newUriMsg = null;
            this.log.debug("Extracted URI: {}", (Object)extractedUri);
            newUriMsg = baseProperty ? new CrawlUriMessage(extractedUri, extractedUri, wonNodeUri, CrawlUriMessage.STATUS.PROCESS, crawlDate, etags) : new CrawlUriMessage(extractedUri, baseUri, wonNodeUri, CrawlUriMessage.STATUS.PROCESS, crawlDate, etags);
            newCrawlMessages.add(newUriMsg);
        }
        qexec.close();
        return newCrawlMessages;
    }

    public String retrieveNeedModificationDateForCrawling(String wonNodeUri) {
        String queryString = "SELECT ?modificationDate WHERE {\n ?needUri a won:Need.\n ?needUri won:hasWonNode ?wonNodeUri. \n ?needUri dcterms:modified ?modificationDate. \n ?needUri won:crawlStatus 'DONE'. \n} ORDER BY DESC(?modificationDate) LIMIT 1\n";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setNsPrefix("won", "http://purl.org/webofneeds/model#");
        pps.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        pps.setCommandText(queryString);
        pps.setIri("wonNodeUri", wonNodeUri);
        QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());
        ResultSet results = qexec.execSelect();
        String modificationDate = null;
        if (results.hasNext()) {
            QuerySolution qs = results.nextSolution();
            modificationDate = qs.get("modificationDate").asLiteral().getString();
        }
        qexec.close();
        return modificationDate;
    }

    public String retrieveConnectionModificationDateForCrawling(String wonNodeUri) {
        String queryString = "SELECT ?modificationDate WHERE {\n ?connectionUri a won:Connection.\n ?connectionUri won:hasWonNode ?wonNodeUri. \n ?connectionUri dcterms:modified ?modificationDate. \n ?connectionUri won:crawlStatus 'DONE'. \n} ORDER BY DESC(?modificationDate) LIMIT 1\n";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setNsPrefix("won", "http://purl.org/webofneeds/model#");
        pps.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        pps.setCommandText(queryString);
        pps.setIri("wonNodeUri", wonNodeUri);
        QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());
        ResultSet results = qexec.execSelect();
        String modificationDate = null;
        if (results.hasNext()) {
            QuerySolution qs = results.nextSolution();
            modificationDate = qs.get("modificationDate").asLiteral().getString();
        }
        qexec.close();
        return modificationDate;
    }

    public BulkNeedEvent retrieveActiveNeedEvents(long fromDate, long toDate, int offset, int limit, boolean sortAscending) {
        String orderClause = sortAscending ? "ORDER BY ?date\n" : "ORDER BY DESC(?date)\n";
        this.log.debug("bulk load need data from sparql endpoint in date range: [{},{}]", (Object)fromDate, (Object)toDate);
        String queryTemplate = "SELECT ?needUri ?wonNodeUri ?date WHERE {  \n  ?needUri a won:Need. \n  ?needUri won:crawlDate ?date.  \n  ?needUri won:isInState won:Active. \n  ?needUri won:hasWonNode ?wonNodeUri. \n  {?needUri won:crawlStatus 'SAVE'.} UNION {?needUri won:crawlStatus 'DONE'.}\n  FILTER (?date >= ?fromDate && ?date < ?toDate ) \n} " + orderClause + " OFFSET ?offset\n LIMIT ?limit";
        ParameterizedSparqlString pps = new ParameterizedSparqlString();
        pps.setNsPrefix("won", "http://purl.org/webofneeds/model#");
        pps.setCommandText(queryTemplate);
        pps.setLiteral("fromDate", fromDate);
        pps.setLiteral("toDate", toDate);
        pps.setLiteral("offset", offset);
        pps.setLiteral("limit", limit);
        this.log.debug("Query SPARQL Endpoint: {}", (Object)this.sparqlEndpoint);
        this.log.debug("Execute query: {}", (Object)pps.toString());
        QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.sparqlEndpoint, (Query)pps.asQuery());
        ResultSet results = qexec.execSelect();
        BulkNeedEvent bulkNeedEvent = new BulkNeedEvent();
        while (results.hasNext()) {
            QuerySolution qs = results.nextSolution();
            String needUri = qs.get("needUri").asResource().getURI();
            String wonNodeUri = qs.get("wonNodeUri").asResource().getURI();
            long crawlDate = qs.getLiteral("date").getLong();
            Dataset ds = this.retrieveNeedDataset(needUri);
            StringWriter sw = new StringWriter();
            RDFDataMgr.write((StringWriter)sw, (Dataset)ds, (Lang)RDFFormat.TRIG.getLang());
            NeedEvent needEvent = new NeedEvent(needUri, wonNodeUri, NeedEvent.TYPE.ACTIVE, crawlDate, sw.toString(), RDFFormat.TRIG.getLang());
            bulkNeedEvent.addNeedEvent(needEvent);
        }
        qexec.close();
        this.log.debug("number of need events created: " + bulkNeedEvent.getNeedEvents().size());
        return bulkNeedEvent;
    }
}

