/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.crawler.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.shared.Lock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import won.matcher.service.common.event.NeedEvent;
import won.matcher.service.common.service.sparql.SparqlService;
import won.matcher.service.crawler.config.CrawlConfig;
import won.matcher.service.crawler.exception.CrawlWrapperException;
import won.matcher.service.crawler.msg.CrawlUriMessage;
import won.matcher.service.crawler.msg.ResourceCrawlUriMessage;
import won.matcher.service.crawler.service.CrawlSparqlService;
import won.protocol.exception.IncorrectPropertyCountException;
import won.protocol.model.NeedState;
import won.protocol.rest.DatasetResponseWithStatusCodeAndHeaders;
import won.protocol.util.NeedModelWrapper;
import won.protocol.util.RdfUtils;
import won.protocol.util.linkeddata.LinkedDataSourceBase;
import won.protocol.vocabulary.WON;

@Component
@Scope(value="prototype")
public class WorkerCrawlerActor
extends UntypedActor {
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    @Autowired
    private LinkedDataSourceBase linkedDataSource;
    @Autowired
    private CrawlSparqlService sparqlService;
    @Autowired
    private CrawlConfig config;
    private ActorRef pubSubMediator;

    public void preStart() {
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
    }

    public void onReceive(Object msg) throws RestClientException {
        if (!(msg instanceof CrawlUriMessage)) {
            this.unhandled(msg);
            return;
        }
        CrawlUriMessage uriMsg = (CrawlUriMessage)msg;
        if (!uriMsg.getStatus().equals((Object)CrawlUriMessage.STATUS.PROCESS) && !uriMsg.getStatus().equals((Object)CrawlUriMessage.STATUS.SAVE)) {
            this.unhandled(msg);
            return;
        }
        this.crawlUri(uriMsg);
    }

    private void crawlUri(CrawlUriMessage uriMsg) {
        Dataset ds = null;
        List etags = null;
        Lock lock = null;
        try {
            ResourceCrawlUriMessage resMsg;
            if (uriMsg instanceof ResourceCrawlUriMessage && (resMsg = (ResourceCrawlUriMessage)uriMsg).getSerializedResource() != null && resMsg.getSerializationFormat() != null) {
                ds = SparqlService.deserializeDataset(resMsg.getSerializedResource(), resMsg.getSerializationFormat());
            }
            if (ds == null) {
                HttpHeaders httpHeaders = new HttpHeaders();
                if (uriMsg.getResourceETagHeaderValues() != null && !uriMsg.getResourceETagHeaderValues().isEmpty()) {
                    String ifNoneMatchHeaderValue = StringUtils.collectionToDelimitedString(uriMsg.getResourceETagHeaderValues(), (String)", ");
                    httpHeaders.add("If-None-Match", ifNoneMatchHeaderValue);
                }
                DatasetResponseWithStatusCodeAndHeaders datasetWithHeaders = this.linkedDataSource.getDatasetWithHeadersForResource(URI.create(uriMsg.getUri()), httpHeaders);
                ds = datasetWithHeaders.getDataset();
                etags = datasetWithHeaders.getResponseHeaders().get((Object)"ETag");
                if (ds == null && datasetWithHeaders.getStatusCode() == 304) {
                    this.sendDoneUriMessage(uriMsg, uriMsg.getWonNodeUri(), etags);
                    return;
                }
                String prevLink = this.linkedDataSource.getPreviousLinkFromDatasetWithHeaders(datasetWithHeaders);
                if (prevLink != null) {
                    CrawlUriMessage newUriMsg = new CrawlUriMessage(uriMsg.getBaseUri(), prevLink, uriMsg.getWonNodeUri(), CrawlUriMessage.STATUS.PROCESS, System.currentTimeMillis(), null);
                    this.getSender().tell((Object)newUriMsg, this.getSelf());
                }
            }
            lock = ds == null ? null : ds.getLock();
            lock.enterCriticalSection(true);
            this.sparqlService.updateNamedGraphsOfDataset(ds);
            String wonNodeUri = this.extractWonNodeUri(ds, uriMsg.getUri());
            if (wonNodeUri == null) {
                wonNodeUri = uriMsg.getWonNodeUri();
            }
            if (uriMsg.getStatus().equals((Object)CrawlUriMessage.STATUS.SAVE)) {
                this.log.debug("processed crawl uri event {} with status 'SAVE'", (Object)uriMsg);
                return;
            }
            this.log.debug("Extract URIs from message {}", (Object)uriMsg);
            Set<CrawlUriMessage> newCrawlMessages = this.sparqlService.extractCrawlUriMessages(uriMsg.getBaseUri(), wonNodeUri);
            for (CrawlUriMessage newMsg : newCrawlMessages) {
                this.getSender().tell((Object)newMsg, this.getSelf());
            }
            this.sendDoneUriMessage(uriMsg, wonNodeUri, etags);
            if (NeedModelWrapper.isANeed((Dataset)ds)) {
                NeedModelWrapper needModelWrapper = new NeedModelWrapper(ds, false);
                NeedState state = needModelWrapper.getNeedState();
                NeedEvent.TYPE type = state.equals((Object)NeedState.ACTIVE) ? NeedEvent.TYPE.ACTIVE : NeedEvent.TYPE.INACTIVE;
                this.log.debug("Created need event for need uri {}", (Object)uriMsg.getUri());
                long crawlDate = System.currentTimeMillis();
                NeedEvent needEvent = new NeedEvent(uriMsg.getUri(), wonNodeUri, type, crawlDate, ds);
                this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(needEvent.getClass().getName(), (Object)needEvent), this.getSelf());
            }
        }
        catch (RestClientException e1) {
            this.log.debug("Exception during crawling: " + (Object)((Object)e1));
            throw new CrawlWrapperException((Exception)((Object)e1), uriMsg);
        }
        catch (Exception e) {
            this.log.debug("Exception during crawling: " + e);
            throw new CrawlWrapperException(e, uriMsg);
        }
        finally {
            if (lock != null) {
                lock.leaveCriticalSection();
            }
        }
    }

    private String extractWonNodeUri(Dataset ds, String uri) {
        try {
            return RdfUtils.findOnePropertyFromResource((Dataset)ds, (URI)URI.create(uri), (Property)WON.HAS_WON_NODE).asResource().getURI();
        }
        catch (IncorrectPropertyCountException e) {
            return null;
        }
    }

    private void sendDoneUriMessage(CrawlUriMessage sourceUriMessage, String wonNodeUri, Collection<String> etags) {
        long crawlDate = System.currentTimeMillis();
        CrawlUriMessage uriDoneMsg = new CrawlUriMessage(sourceUriMessage.getUri(), sourceUriMessage.getBaseUri(), wonNodeUri, CrawlUriMessage.STATUS.DONE, crawlDate, etags);
        String ifNoneMatch = sourceUriMessage.getResourceETagHeaderValues() != null ? String.join((CharSequence)", ", sourceUriMessage.getResourceETagHeaderValues()) : "<None>";
        String responseETags = etags != null ? String.join((CharSequence)", ", etags) : "<None>";
        this.log.debug("Crawling done for URI {} with ETag Header Values {} (If-None-Match request value: {})", (Object)uriDoneMsg.getUri(), (Object)responseETags, (Object)ifNoneMatch);
        this.getSender().tell((Object)uriDoneMsg, this.getSelf());
    }

    public void setSparqlService(CrawlSparqlService sparqlService) {
        this.sparqlService = sparqlService;
    }
}

