/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.crawler.actor;

import akka.actor.ActorSystem;
import akka.actor.OneForOneStrategy;
import akka.actor.SupervisorStrategy;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.japi.Function;
import java.util.Collection;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import won.matcher.service.crawler.config.CrawlConfig;
import won.matcher.service.crawler.msg.CrawlUriMessage;
import won.matcher.service.crawler.service.CrawlSparqlService;

@Component
@Scope(value="prototype")
public class UpdateMetadataActor
extends UntypedActor {
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private Collection<CrawlUriMessage> bulkMessages = new LinkedList<CrawlUriMessage>();
    private static final String TICK = "tick";
    @Autowired
    private CrawlConfig config;
    @Autowired
    private CrawlSparqlService endpoint;

    public void preStart() {
        this.getContext().system().scheduler().schedule(this.config.getMetaDataUpdateMaxDuration(), this.config.getMetaDataUpdateMaxDuration(), this.getSelf(), (Object)TICK, (ExecutionContext)this.getContext().dispatcher(), null);
    }

    public void postStop() {
        this.update();
    }

    public void onReceive(Object message) {
        if (message instanceof CrawlUriMessage) {
            CrawlUriMessage uriMsg = (CrawlUriMessage)message;
            this.log.debug("Add message to bulk update list: {}", (Object)uriMsg);
            this.bulkMessages.add(uriMsg);
            if ((long)this.bulkMessages.size() >= this.config.getMetaDataUpdateMaxBulkSize()) {
                this.update();
            }
        } else if (message instanceof String) {
            this.update();
        } else {
            this.unhandled(message);
        }
    }

    private void update() {
        if (this.bulkMessages.size() > 0) {
            this.log.debug("Update crawling meta data of {} messages", (Object)this.bulkMessages.size());
            this.endpoint.bulkUpdateCrawlingMetadata(this.bulkMessages);
            this.bulkMessages.clear();
        }
    }

    public SupervisorStrategy supervisorStrategy() {
        OneForOneStrategy supervisorStrategy = new OneForOneStrategy(0, (Duration)Duration.Zero(), (Function)new Function<Throwable, SupervisorStrategy.Directive>(){

            public SupervisorStrategy.Directive apply(Throwable t) throws Exception {
                UpdateMetadataActor.this.log.warning("Actor encountered error: {}", (Object)t);
                return SupervisorStrategy.escalate();
            }
        });
        return supervisorStrategy;
    }
}

