/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.crawler.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import won.matcher.service.common.event.BulkNeedEvent;
import won.matcher.service.common.event.LoadNeedEvent;
import won.matcher.service.crawler.service.CrawlSparqlService;

@Component
@Scope(value="prototype")
public class NeedEventLoaderActor
extends UntypedActor {
    private static int MAX_BULK_SIZE = 10;
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private ActorRef pubSubMediator;
    @Autowired
    private CrawlSparqlService sparqlService;

    public void preStart() {
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Subscribe(LoadNeedEvent.class.getName(), this.getSelf()), this.getSelf());
    }

    public void onReceive(Object o) throws Throwable {
        if (o instanceof LoadNeedEvent) {
            BulkNeedEvent bulkNeedEvent;
            LoadNeedEvent msg = (LoadNeedEvent)o;
            this.log.debug("received request to load needs events: {}", (Object)msg);
            int offset = 0;
            do {
                if ((bulkNeedEvent = msg.getLastXNeedEvents() == -1 ? this.sparqlService.retrieveActiveNeedEvents(msg.getFromDate(), msg.getToDate(), offset, MAX_BULK_SIZE, true) : this.sparqlService.retrieveActiveNeedEvents(0L, Long.MAX_VALUE, offset, Math.min(MAX_BULK_SIZE, msg.getLastXNeedEvents() - offset), false)).getNeedEvents().size() <= 0) continue;
                this.log.debug("send bulk event of size {} back to requesting actor", (Object)bulkNeedEvent.getNeedEvents().size());
                this.getSender().tell((Object)bulkNeedEvent, this.getSelf());
                offset += bulkNeedEvent.getNeedEvents().size();
            } while (bulkNeedEvent.getNeedEvents().size() == MAX_BULK_SIZE);
        }
    }
}

