/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.common.service.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class MonitoringService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NEED_HINT_STOPWATCH = "NeedReceivedUntilFirstHintSent";
    private Map<String, Map<String, Split>> stopWatchSplits = new HashMap<String, Map<String, Split>>();
    @Value(value="${matcher.service.monitoring}")
    private boolean monitoringEnabled;

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void startClock(String stopWatchName, String splitName) {
        if (this.isMonitoringEnabled()) {
            Map<String, Split> splits = this.stopWatchSplits.get(stopWatchName);
            if (splits == null) {
                splits = new HashMap<String, Split>();
                this.stopWatchSplits.put(stopWatchName, splits);
            }
            if (splits.get(splitName) != null) {
                this.log.warn("Split '{}' in stopwatch {} already set for monitoring start event", (Object)splitName, (Object)stopWatchName);
                return;
            }
            Stopwatch stopwatch = SimonManager.getStopwatch((String)stopWatchName);
            Split split = stopwatch.start();
            splits.put(splitName, split);
        }
    }

    public void stopClock(String stopWatchName, String splitName) {
        if (this.isMonitoringEnabled()) {
            Map<String, Split> splits = this.stopWatchSplits.get(stopWatchName);
            if (splits == null) {
                this.log.warn("No stopwatch '{}' found for monitoring end event", (Object)stopWatchName);
                return;
            }
            Split split = splits.get(splitName);
            if (split == null) {
                this.log.warn("No split '{}' in stopwatch '{}' found for monitoring end event", (Object)splitName, (Object)stopWatchName);
                return;
            }
            split.stop();
        }
    }
}

