/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.service.common.service.http;

import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
@Scope(value="prototype")
public class HttpService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private RestTemplate restTemplate;
    private HttpHeaders jsonHeaders;

    public HttpService() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        this.init((ClientHttpRequestFactory)factory);
    }

    public HttpService(int readTimeout, int connectionTimeout) {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setReadTimeout(readTimeout);
        factory.setConnectTimeout(connectionTimeout);
        this.init((ClientHttpRequestFactory)factory);
    }

    private void init(ClientHttpRequestFactory factory) {
        this.restTemplate = new RestTemplate(factory);
        this.restTemplate.getMessageConverters().add(new StringHttpMessageConverter(Charset.forName("UTF-8")));
        this.jsonHeaders = new HttpHeaders();
        this.jsonHeaders.add("Content-Type", "application/json");
        this.jsonHeaders.add("Accept", "*/*");
    }

    public void postJsonRequest(String uri, String body) {
        ResponseEntity response = null;
        this.log.debug("POST URI: {}", (Object)uri);
        HttpEntity jsonEntity = new HttpEntity((Object)body, (MultiValueMap)this.jsonHeaders);
        response = this.restTemplate.exchange(uri, HttpMethod.POST, jsonEntity, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            this.log.warn("HTTP POST request returned status code: {}", (Object)response.getStatusCode());
            throw new HttpClientErrorException(response.getStatusCode());
        }
    }
}

