/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.impl;

import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import won.cryptography.rdfsign.SignatureVerificationState;
import won.cryptography.rdfsign.SigningStage;
import won.cryptography.rdfsign.WonHasher;
import won.cryptography.rdfsign.WonSigner;
import won.cryptography.rdfsign.WonVerifier;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageUtils;
import won.protocol.message.WonSignatureData;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonMessageUriHelper;
import won.protocol.util.WonRdfUtils;
import won.protocol.vocabulary.WONMSG;

public class WonMessageSignerVerifier {
    public static WonMessage seal(WonMessage message) throws Exception {
        Dataset ds = message.getCompleteDataset();
        WonMessageSignerVerifier.calculateMessageUriForContent(ds);
        return WonMessage.of((Dataset)ds);
    }

    public static WonMessage signAndSeal(PrivateKey privateKey, PublicKey publicKey, String privateKeyUri, WonMessage message) throws Exception {
        Dataset msgDataset = message.getCompleteDataset();
        SigningStage sigStage = new SigningStage(message);
        WonSigner signer = new WonSigner(msgDataset);
        if (message.getMessageTypeRequired().isContentSignedSeparately()) {
            WonMessageSignerVerifier.signContents(msgDataset, sigStage, signer, privateKey, privateKeyUri, publicKey);
            WonMessageSignerVerifier.signEnvelope(msgDataset, sigStage, signer, privateKey, privateKeyUri, publicKey, message.getMessageURIRequired());
        } else {
            WonMessageSignerVerifier.signWholeMessage(msgDataset, sigStage, signer, privateKey, privateKeyUri, publicKey, message.getMessageURIRequired());
        }
        WonMessageSignerVerifier.calculateMessageUriForContent(msgDataset);
        return WonMessage.of((Dataset)msgDataset);
    }

    public static SignatureVerificationState verify(Map<String, PublicKey> keys, WonMessage message) throws Exception {
        Dataset ds = message.getCompleteDataset();
        RdfUtils.renameResourceWithPrefix((Dataset)ds, (String)message.getMessageURIRequired().toString(), (String)WonMessageUriHelper.getSelfUri().toString());
        WonVerifier verifier = new WonVerifier(WonMessage.of((Dataset)ds));
        verifier.verify(keys);
        return verifier.getVerificationResult();
    }

    private static void signEnvelope(Dataset msgDataset, SigningStage sigStage, WonSigner signer, PrivateKey privateKey, String privateKeyUri, PublicKey publicKey, URI messageURI) throws Exception {
        WonSignatureData wonSignatureData = null;
        String envUri = sigStage.getEnvelopeUri();
        wonSignatureData = signer.signNamedGraphsSeparately(privateKey, privateKeyUri, publicKey, envUri).get(0);
        Objects.requireNonNull(wonSignatureData);
        String signatureUri = messageURI.toString() + "#signature";
        wonSignatureData.setSignatureUri(signatureUri);
        msgDataset.addNamedModel(signatureUri, ModelFactory.createDefaultModel());
        WonMessageSignerVerifier.addSignature(wonSignatureData, signatureUri, msgDataset, false);
    }

    private static void signWholeMessage(Dataset msgDataset, SigningStage sigStage, WonSigner signer, PrivateKey privateKey, String privateKeyUri, PublicKey publicKey, URI messageURI) throws Exception {
        WonSignatureData wonSignatureData = null;
        String signatureUri = WonMessageUtils.stripFragment((URI)messageURI).toString() + "#signature";
        wonSignatureData = signer.signWholeDataset(privateKey, privateKeyUri, publicKey, signatureUri);
        Objects.requireNonNull(wonSignatureData);
        msgDataset.addNamedModel(wonSignatureData.getSignatureUri(), ModelFactory.createDefaultModel());
        WonMessageSignerVerifier.addSignature(wonSignatureData, wonSignatureData.getSignatureUri(), msgDataset, false);
    }

    private static void addSignature(WonSignatureData sigData, String graphUri, Dataset msgDataset, boolean graphIsEnvelope) {
        Model graph = msgDataset.getNamedModel(graphUri);
        Resource graphNode = graph.createResource(graphUri);
        Resource sigNode = graph.createResource(sigData.getSignatureUri());
        if (graphIsEnvelope) {
            graphNode.addProperty(WONMSG.containsSignature, (RDFNode)sigNode);
        } else if (Objects.equals(graphNode.getURI(), sigNode.getURI())) {
            URI messageURI = WonMessageUtils.stripFragment((URI)URI.create(graphUri));
            Resource msgNode = graph.getResource(messageURI.toString());
            graph.add(msgNode, WONMSG.signature, (RDFNode)sigNode);
        }
        WonRdfUtils.SignatureUtils.addSignature((Resource)sigNode, (WonSignatureData)sigData);
    }

    private static void calculateMessageUriForContent(Dataset msgDataset) throws Exception {
        WonHasher hasher = new WonHasher();
        String hashId = hasher.calculateHashIdForDataset(msgDataset);
        RdfUtils.renameResourceWithPrefix((Dataset)msgDataset, (String)WonMessageUriHelper.getSelfUri().toString(), (String)WonMessageUriHelper.createMessageURIForId((String)hashId).toString());
    }

    private static void signContents(Dataset msgDataset, SigningStage sigStage, WonSigner signer, PrivateKey privateKey, String privateKeyUri, PublicKey publicKey) throws Exception {
        List<WonSignatureData> sigRefs = signer.sign(privateKey, privateKeyUri, publicKey, sigStage.getUnsignedContentUris());
        for (WonSignatureData sigRef : sigRefs) {
            String envUri = sigStage.getEnvelopeUri();
            WonMessageSignerVerifier.addSignature(sigRef, envUri, msgDataset, true);
        }
    }
}

