/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StopWatch;
import won.cryptography.rdfsign.WonKeysReaderWriter;
import won.protocol.exception.WonMessageProcessingException;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.util.LogMarkers;
import won.protocol.util.linkeddata.LinkedDataSource;

public class SignatureCheckingWonMessageProcessor
implements WonMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Ehcache webIdCache;
    @Autowired
    private LinkedDataSource linkedDataSource;

    public SignatureCheckingWonMessageProcessor() {
        CacheManager manager = CacheManager.getInstance();
        this.webIdCache = new Cache("SignatureCheckingWonMessageProcessor", 100, false, false, 3600L, 3600L);
        manager.addCache(this.webIdCache);
    }

    public void setLinkedDataSource(LinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }

    /*
     * Exception decompiling
     */
    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean appendIfPresent(URI uri, String label, StringBuilder sb) {
        if (uri != null) {
            sb.append(label).append(": ").append(uri);
            return true;
        }
        return false;
    }

    private Map<String, PublicKey> getRequiredPublicKeys(Dataset msgDataset) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        StopWatch sw = new StopWatch();
        sw.start("read embedded keys");
        WonKeysReaderWriter keyReader = new WonKeysReaderWriter();
        Map<String, PublicKey> keys = keyReader.readFromDataset(msgDataset);
        sw.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("Embedded keys: {}", keys.keySet());
        }
        sw.start("extract referenced keys");
        Set<String> refKeys = keyReader.readKeyReferences(msgDataset);
        sw.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("referenced keys: " + Arrays.toString(refKeys.toArray()));
        }
        for (String refKey : refKeys) {
            if (keys.containsKey(refKey)) continue;
            logger.debug("loading referenced key {}", (Object)refKey);
            sw.start("load referenced key");
            Set<PublicKey> resolvedKeys = this.loadKey(refKey, keyReader);
            sw.stop();
            Iterator<PublicKey> iterator = resolvedKeys.iterator();
            if (!iterator.hasNext()) continue;
            PublicKey resolvedKey = iterator.next();
            keys.put(refKey, resolvedKey);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("retrieved public keys of these webids: " + Arrays.toString(keys.keySet().toArray()));
            logger.debug(LogMarkers.TIMING, "Timing info: \n{}", (Object)sw.prettyPrint());
        }
        return keys;
    }

    public Set<PublicKey> loadKey(String keyURI, WonKeysReaderWriter keyReader) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        Element cachedElement = this.webIdCache.get((Serializable)((Object)keyURI));
        if (cachedElement != null) {
            return (Set)cachedElement.getObjectValue();
        }
        Set<PublicKey> ret = this.loadKeyRemotely(keyReader, keyURI);
        if (ret != null && ret.size() > 0) {
            this.webIdCache.put(new Element((Object)keyURI, ret));
        }
        return ret;
    }

    public Set<PublicKey> loadKeyRemotely(WonKeysReaderWriter keyReader, String refKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        Dataset keyDataset = this.linkedDataSource.getDataForResource(URI.create(refKey));
        Set<PublicKey> resolvedKeys = keyReader.readFromDataset(keyDataset, refKey);
        return resolvedKeys;
    }
}

