/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.impl;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.cryptography.keymanagement.KeyPairAliasDerivationStrategy;
import won.cryptography.service.CryptographyService;
import won.protocol.exception.WonMessageProcessingException;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.impl.WonMessageSignerVerifier;
import won.protocol.util.Prefixer;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonMessageUriHelper;

public class SignatureAddingWonMessageProcessor
implements WonMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private CryptographyService cryptographyService;
    @Autowired(required=false)
    private KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy;

    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        return this.signWithDefaultKey(message);
    }

    public WonMessage signWithDefaultKey(WonMessage message) throws WonMessageProcessingException {
        PrivateKey privateKey = this.cryptographyService.getDefaultPrivateKey();
        String webId = this.cryptographyService.getDefaultPrivateKeyAlias();
        PublicKey publicKey = this.cryptographyService.getPublicKey(webId);
        try {
            ArrayList<WonMessage> ret = new ArrayList<WonMessage>();
            for (WonMessage part : message.getAllMessages()) {
                ret.add(this.processWithKey(part, webId, privateKey, publicKey));
            }
            return WonMessage.of(ret);
        }
        catch (Exception e) {
            logger.error("Failed to sign", (Throwable)e);
            throw new WonMessageProcessingException("Failed to sign message " + message.getMessageURI().toString());
        }
    }

    public WonMessage signWithAtomKey(WonMessage wonMessage) throws WonMessageProcessingException {
        ArrayList<WonMessage> ret = new ArrayList<WonMessage>();
        for (WonMessage message : wonMessage.getAllMessages()) {
            Optional<URI> senderAtomURI = Optional.of(message.getSenderAtomURIRequired());
            String alias = this.keyPairAliasDerivationStrategy.getAliasForAtomUri(senderAtomURI.get().toString());
            PrivateKey privateKey = this.cryptographyService.getPrivateKey(alias);
            PublicKey publicKey = this.cryptographyService.getPublicKey(alias);
            Objects.requireNonNull(publicKey);
            Objects.requireNonNull(publicKey);
            try {
                ret.add(this.processWithKey(message, senderAtomURI.get().toString(), privateKey, publicKey));
            }
            catch (Exception e) {
                logger.error("Failed to sign", (Throwable)e);
                throw new WonMessageProcessingException("Failed to sign message " + message.getMessageURI().toString(), (Throwable)e);
            }
        }
        return WonMessage.of(ret);
    }

    private WonMessage processWithKey(WonMessage wonMessage, String privateKeyUri, PrivateKey privateKey, PublicKey publicKey) throws Exception {
        URI messageURI = wonMessage.getMessageURIRequired();
        if (!Objects.equals(messageURI, WonMessageUriHelper.getSelfUri())) {
            return wonMessage;
        }
        WonMessage signed = WonMessageSignerVerifier.signAndSeal(privateKey, publicKey, privateKeyUri, wonMessage);
        if (logger.isDebugEnabled()) {
            logger.debug("SIGNED with key " + privateKeyUri + ":\n" + RdfUtils.toString((Dataset)Prefixer.setPrefixes((Dataset)signed.getCompleteDataset())));
        }
        return signed;
    }

    public void setCryptographyService(CryptographyService cryptoService) {
        this.cryptographyService = cryptoService;
    }

    public void setKeyPairAliasDerivationStrategy(KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy) {
        this.keyPairAliasDerivationStrategy = keyPairAliasDerivationStrategy;
    }
}

