/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.impl;

import java.lang.invoke.MethodHandles;
import java.security.PublicKey;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.cryptography.keymanagement.KeyPairAliasDerivationStrategy;
import won.cryptography.rdfsign.WonKeysReaderWriter;
import won.cryptography.service.CryptographyService;
import won.protocol.exception.WonMessageProcessingException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageEncoder;
import won.protocol.message.WonMessageType;
import won.protocol.message.processor.WonMessageProcessor;

public class KeyForNewAtomAddingProcessor
implements WonMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private CryptographyService cryptographyService;
    @Autowired
    private KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy;

    public void setCryptographyService(CryptographyService cryptoService) {
        this.cryptographyService = cryptoService;
    }

    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        try {
            if (message.getMessageType() == WonMessageType.CREATE_ATOM) {
                String atomUri = message.getAtomURIRequired().toString();
                Dataset msgDataset = WonMessageEncoder.encodeAsDataset((WonMessage)message);
                String alias = this.keyPairAliasDerivationStrategy.getAliasForAtomUri(atomUri);
                if (this.cryptographyService.getPrivateKey(alias) == null) {
                    this.cryptographyService.createNewKeyPair(alias, alias);
                }
                PublicKey pubKey = this.cryptographyService.getPublicKey(alias);
                WonKeysReaderWriter keyWriter = new WonKeysReaderWriter();
                String contentName = (String)message.getContentGraphURIs().get(0);
                Model contentModel = msgDataset.getNamedModel(contentName);
                keyWriter.writeToModel(contentModel, contentModel.createResource(atomUri), pubKey);
                return WonMessage.of((Dataset)msgDataset);
            }
            if (message.getMessageType() == WonMessageType.REPLACE) {
                String atomUri = message.getAtomURIRequired().toString();
                Dataset msgDataset = WonMessageEncoder.encodeAsDataset((WonMessage)message);
                String alias = this.keyPairAliasDerivationStrategy.getAliasForAtomUri(atomUri);
                if (this.cryptographyService.getPrivateKey(alias) == null) {
                    throw new IllegalStateException("Cannot replace atom " + atomUri + ": no key pair found");
                }
                PublicKey pubKey = this.cryptographyService.getPublicKey(alias);
                WonKeysReaderWriter keyWriter = new WonKeysReaderWriter();
                String contentName = (String)message.getContentGraphURIs().get(0);
                Model contentModel = msgDataset.getNamedModel(contentName);
                keyWriter.writeToModel(contentModel, contentModel.createResource(atomUri), pubKey);
                return WonMessage.of((Dataset)msgDataset);
            }
        }
        catch (Exception e) {
            logger.error("Failed to add key", (Throwable)e);
            throw new WonMessageProcessingException("Failed to add key for atom in message " + message.getMessageURI().toString(), (Throwable)e);
        }
        return message;
    }

    public void setKeyPairAliasDerivationStrategy(KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy) {
        this.keyPairAliasDerivationStrategy = keyPairAliasDerivationStrategy;
    }
}

