/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.webid;

import java.io.Serializable;
import java.net.URI;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import won.cryptography.rdfsign.WonKeysReaderWriter;
import won.protocol.util.linkeddata.LinkedDataSource;

public class WebIDVerificationAgent {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LinkedDataSource linkedDataSource;
    private final Ehcache webIdCache;

    public WebIDVerificationAgent() {
        CacheManager manager = CacheManager.getInstance();
        this.webIdCache = new Cache("WebIDVerificationAgent", 100, false, false, 3600L, 3600L);
        manager.addCache(this.webIdCache);
    }

    public boolean verify(PublicKey publicKey, URI webId) {
        if (publicKey instanceof ECPublicKey) {
            Set<PublicKey> keys;
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            WonKeysReaderWriter ecKeyReader = new WonKeysReaderWriter();
            boolean isCached = false;
            try {
                Element cachedElement = this.webIdCache.get((Serializable)webId);
                if (cachedElement != null) {
                    keys = (Set<PublicKey>)cachedElement.getObjectValue();
                    isCached = true;
                } else {
                    Dataset dataset = this.linkedDataSource.getDataForResource(webId);
                    keys = ecKeyReader.readFromDataset(dataset, webId.toString());
                }
            }
            catch (Exception e) {
                throw new InternalAuthenticationServiceException("Could not verify key", (Throwable)e);
            }
            for (PublicKey key : keys) {
                if (!this.isSameKey(ecPublicKey, key)) continue;
                if (!isCached) {
                    this.webIdCache.put(new Element((Object)webId, keys));
                }
                return true;
            }
        } else {
            throw new InternalAuthenticationServiceException("Key type " + publicKey.getAlgorithm() + " not supported");
        }
        return false;
    }

    public boolean isSameKey(ECPublicKey ecPublicKey, PublicKey key) {
        ECPublicKey ecPublicKeyFetched = (ECPublicKey)key;
        return ecPublicKey.getW().getAffineX().equals(ecPublicKeyFetched.getW().getAffineX()) && ecPublicKey.getW().getAffineY().equals(ecPublicKeyFetched.getW().getAffineY());
    }

    public List<String> verify(PublicKey publicKey, List<URI> webIDs) throws AuthenticationException {
        ArrayList<String> verified = new ArrayList<String>();
        for (URI webID : webIDs) {
            if (!this.verify(publicKey, webID)) continue;
            verified.add(webID.toString());
        }
        return verified;
    }

    public void setLinkedDataSource(LinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }
}

