/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.GraphCollection;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.SignatureData;
import io.ipfs.multibase.Base58;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.net.URI;
import java.security.PublicKey;
import java.security.Signature;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.rdfsign.ModelConverter;
import won.cryptography.rdfsign.SignatureVerificationState;
import won.cryptography.rdfsign.WonHasher;
import won.protocol.message.WonMessage;
import won.protocol.message.WonSignatureData;
import won.protocol.util.Prefixer;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonMessageUriHelper;
import won.protocol.util.WonRdfUtils;
import won.protocol.vocabulary.WONMSG;

public class WonVerifier {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Dataset dataset;
    private final SignatureVerificationState verificationState = new SignatureVerificationState();
    private final WonHasher hasher = new WonHasher();
    private URI messageURI;

    public WonVerifier(WonMessage message) {
        this.dataset = message.getCompleteDataset();
        this.messageURI = message.getMessageURIRequired();
        this.prepareForVerifying();
    }

    private void prepareForVerifying() {
        for (String graphURI : RdfUtils.getModelNames((Dataset)this.dataset)) {
            Model model;
            if (WonRdfUtils.SignatureUtils.isSignatureGraph((String)graphURI, (Model)(model = this.dataset.getNamedModel(graphURI)))) {
                this.addSignatureToResult(graphURI, model);
                continue;
            }
            this.verificationState.addSignedGraphName(graphURI);
            this.addSignatureReferenceToResult(graphURI, model);
        }
    }

    public SignatureVerificationState getVerificationResult() {
        return this.verificationState;
    }

    private boolean checkMessageURI() throws Exception {
        String idFromMessageURI;
        String hashId = this.hasher.calculateHashIdForDataset(this.dataset);
        if (Objects.equals(hashId, idFromMessageURI = WonMessageUriHelper.getIdFromMessageURI((URI)this.messageURI))) {
            this.verificationState.verificationFailed("messageURI is invalid: expected based on message content: '" + hashId + "', expected '" + idFromMessageURI + "'");
            return false;
        }
        return true;
    }

    public boolean verify(Map<String, PublicKey> publicKeys) throws Exception {
        if (this.verificationState.getSignatures().size() == 0) {
            this.verificationState.verificationFailed("No signatures found");
            return this.verificationState.isVerificationPassed();
        }
        if (this.dataset.getDefaultModel().listStatements().hasNext()) {
            this.verificationState.verificationFailed("unsigned data found in default graph");
            return this.verificationState.isVerificationPassed();
        }
        if (!this.checkMessageURI()) {
            return this.verificationState.isVerificationPassed();
        }
        for (WonSignatureData wonSignatureData : this.verificationState.getSignatures()) {
            if (logger.isDebugEnabled()) {
                String loaded = publicKeys.containsKey(wonSignatureData.getVerificationCertificateUri()) ? "loaded" : "NOT LOADED";
                logger.debug("checking signature {} by certificate {}, which is {}", new Object[]{wonSignatureData.getSignatureUri(), wonSignatureData.getVerificationCertificateUri(), loaded});
            }
            List signedGraphs = wonSignatureData.getSignedGraphUris();
            for (String signedGraph : signedGraphs) {
                if (this.dataset.containsNamedModel(signedGraph)) continue;
                this.verificationState.verificationFailed("Found signature of graph " + signedGraph + " that is not part of this message");
            }
            String sigString = wonSignatureData.getSignatureValue();
            if (sigString == null) {
                this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "Failed to compute a signature value " + wonSignatureData.getSignatureUri());
                return this.verificationState.isVerificationPassed();
            }
            if (sigString.length() == 0) {
                this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "Computed an empty signature value " + wonSignatureData.getSignatureUri());
                return this.verificationState.isVerificationPassed();
            }
            PublicKey publicKey = publicKeys.get(wonSignatureData.getVerificationCertificateUri());
            if (publicKey == null) {
                this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "No public key found for " + wonSignatureData.getSignatureUri());
                if (logger.isDebugEnabled()) {
                    logger.debug("offending message:\n" + RdfUtils.toString((Dataset)Prefixer.setPrefixes((Dataset)this.dataset)));
                }
                return this.verificationState.isVerificationPassed();
            }
            String fingerprint = WonHasher.hashToString(publicKey.getEncoded());
            if (!wonSignatureData.getPublicKeyFingerprint().equals(fingerprint)) {
                this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "Fingerprint computed for the specified public key " + wonSignatureData.getVerificationCertificateUri() + " is " + fingerprint + ", which differs from the value found in signature " + wonSignatureData.getSignatureUri());
                return this.verificationState.isVerificationPassed();
            }
            GraphCollection inputGraph = ModelConverter.modelsToGraphCollection(this.dataset, wonSignatureData.getSignedGraphUris().toArray(new String[wonSignatureData.getSignedGraphUris().size()]));
            SignatureData sigData = this.hasher.hashNamedGraphForSigning(inputGraph);
            BigInteger hashValue = sigData.getHash();
            String hashString = WonHasher.hashToString(hashValue);
            if (!wonSignatureData.getHash().equals(hashString)) {
                this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "Computed hash value " + hashString + " differs from value " + wonSignatureData.getHash() + " found in signature " + wonSignatureData.getSignatureUri());
                if (logger.isDebugEnabled()) {
                    StringWriter sw = new StringWriter();
                    for (String signedGraphUri : wonSignatureData.getSignedGraphUris()) {
                        RDFDataMgr.write((StringWriter)sw, (Model)this.dataset.getNamedModel(signedGraphUri), (Lang)Lang.TRIG);
                    }
                    logger.debug("wrong signature hash for graphs {} with content: {}", (Object)wonSignatureData.getSignedGraphUris(), (Object)sw.toString());
                }
                return this.verificationState.isVerificationPassed();
            }
            Signature sig = Signature.getInstance("NONEwithECDSA", "BC");
            sig.initVerify(publicKey);
            sig.update(hashValue.toByteArray());
            byte[] sigBytes = Base58.decode((String)sigString);
            if (sig.verify(sigBytes)) continue;
            this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "Failed to verify " + wonSignatureData.getSignatureUri() + " with public key " + wonSignatureData.getVerificationCertificateUri());
            return this.verificationState.isVerificationPassed();
        }
        return this.verificationState.isVerificationPassed();
    }

    private void addSignatureToResult(String graphUri, Model model) {
        WonSignatureData wonSignatureData = WonRdfUtils.SignatureUtils.extractWonSignatureData((String)graphUri, (Model)model);
        if (wonSignatureData != null && wonSignatureData.getSignatureValue() != null) {
            this.verificationState.addSignatureData(wonSignatureData);
        }
    }

    private void addSignatureReferenceToResult(String graphURI, Model model) {
        RDFNode tempNode = null;
        StmtIterator si = model.listStatements(null, WONMSG.containsSignature, tempNode);
        while (si.hasNext()) {
            WonSignatureData sigRef = WonRdfUtils.SignatureUtils.extractWonSignatureData((Resource)si.nextStatement().getObject().asResource());
            this.verificationState.addSignatureData(sigRef);
        }
    }
}

