/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.GraphCollection;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.SignatureData;
import io.ipfs.multibase.Base58;
import io.ipfs.multihash.Multihash;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.ext.com.google.common.collect.Streams;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.rdfsign.ModelConverter;
import won.cryptography.rdfsign.WonHasher;
import won.protocol.message.WonSignatureData;

public class WonSigner {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SIGNING_ALGORITHM_NAME = "NONEwithECDSA";
    public static final String SIGNING_ALGORITHM_PROVIDER = "BC";
    public static final String ENV_HASH_ALGORITHM = "sha-256";
    public static final Multihash.Type HASH_ALGORITHM_FOR_MULTIHASH = Multihash.Type.sha2_256;
    private Dataset dataset;
    private WonHasher hasher = new WonHasher();

    public WonSigner(Dataset dataset) {
        this.dataset = dataset;
    }

    public List<WonSignatureData> signNamedGraphsSeparately(PrivateKey privateKey, String cert, PublicKey publicKey, String ... graphsToSign) throws Exception {
        ArrayList<WonSignatureData> sigRefs = new ArrayList<WonSignatureData>(graphsToSign.length);
        String fingerprint = WonHasher.hashToString(publicKey.getEncoded());
        for (String signedGraphUri : graphsToSign) {
            if (logger.isDebugEnabled()) {
                StringWriter sw = new StringWriter();
                RDFDataMgr.write((StringWriter)sw, (Model)this.dataset.getNamedModel(signedGraphUri), (Lang)Lang.TRIG);
                logger.debug("signing graph {} with content: {}", (Object)graphsToSign, (Object)sw.toString());
            }
            String signatureUri = signedGraphUri + "-sig";
            GraphCollection inputGraph = ModelConverter.modelToGraphCollection(signedGraphUri, this.dataset);
            SignatureData sigValue = this.signNamedGraph(inputGraph, privateKey, cert);
            String hash = WonHasher.hashToString(sigValue.getHash());
            WonSignatureData sigRef = new WonSignatureData(Arrays.asList(signedGraphUri), signatureUri, sigValue.getSignature(), hash, fingerprint, cert);
            sigRefs.add(sigRef);
        }
        return sigRefs;
    }

    public WonSignatureData signWholeDataset(PrivateKey privateKey, String cert, PublicKey publicKey, String signatureUri) throws Exception {
        String fingerprint = WonHasher.hashToString(publicKey.getEncoded());
        if (logger.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            RDFDataMgr.write((StringWriter)sw, (Dataset)this.dataset, (Lang)Lang.TRIG);
            logger.debug("signing dataset with content: {}", (Object)sw.toString());
        }
        List graphURIs = Streams.stream((Iterator)this.dataset.listNames()).collect(Collectors.toList());
        GraphCollection inputGraphCollection = ModelConverter.fromDataset(this.dataset);
        SignatureData sigValue = this.sign(this.hasher.hashNamedGraphForSigning(inputGraphCollection), privateKey, cert);
        String hash = WonHasher.hashToString(sigValue.getHash());
        WonSignatureData sigRef = new WonSignatureData(graphURIs, signatureUri, sigValue.getSignature(), hash, fingerprint, cert);
        return sigRef;
    }

    public List<WonSignatureData> sign(PrivateKey privateKey, String cert, PublicKey publicKey, Collection<String> graphsToSign) throws Exception {
        String[] array = new String[graphsToSign.size()];
        return this.signNamedGraphsSeparately(privateKey, cert, publicKey, graphsToSign.toArray(array));
    }

    private SignatureData signNamedGraph(GraphCollection inputWithOneNamedGraph, PrivateKey privateKey, String cert) throws Exception {
        return this.sign(this.hasher.hashNamedGraphForSigning(inputWithOneNamedGraph), privateKey, cert);
    }

    private SignatureData sign(SignatureData sigData, PrivateKey privateKey, String verificationCertificate) throws Exception {
        verificationCertificate = verificationCertificate == null ? "\"cert\"" : "<" + verificationCertificate + ">";
        if (sigData == null) {
            throw new Exception("GraphCollection has no signature data. Call 'canonicalize' and 'hash' methods first.");
        }
        Signature sig = Signature.getInstance(SIGNING_ALGORITHM_NAME, SIGNING_ALGORITHM_PROVIDER);
        sig.initSign(privateKey);
        sig.update(sigData.getHash().toByteArray());
        byte[] signatureBytes = sig.sign();
        String signature = Base58.encode((byte[])signatureBytes);
        sigData.setSignature(signature);
        sigData.setSignatureMethod(privateKey.getAlgorithm().toLowerCase());
        sigData.setVerificationCertificate(verificationCertificate);
        return sigData;
    }
}

