/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.transaction.NotSupportedException;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import won.cryptography.exception.KeyNotSupportedException;
import won.cryptography.key.KeyInformationExtractorBouncyCastle;
import won.cryptography.rdfsign.WonEccPublicKey;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.CERT;
import won.protocol.vocabulary.WON;
import won.protocol.vocabulary.WONMSG;

public class WonKeysReaderWriter {
    public Map<String, PublicKey> readFromDataset(Dataset dataset) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        HashMap<String, PublicKey> keys = new HashMap<String, PublicKey>();
        this.readFromModel(dataset.getDefaultModel(), keys);
        for (String name : RdfUtils.getModelNames((Dataset)dataset)) {
            this.readFromModel(dataset.getNamedModel(name), keys);
        }
        return keys;
    }

    public Set<PublicKey> readFromDataset(Dataset dataset, String keyUri) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        PublicKey key = this.readFromModel(dataset.getDefaultModel(), keyUri);
        HashSet<PublicKey> keys = new HashSet<PublicKey>();
        if (key != null) {
            keys.add(key);
        }
        for (String name : RdfUtils.getModelNames((Dataset)dataset)) {
            key = this.readFromModel(dataset.getNamedModel(name), keyUri);
            if (key == null) continue;
            keys.add(key);
        }
        return keys;
    }

    public Map<String, PublicKey> readFromModel(Model model) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        HashMap<String, PublicKey> keys = new HashMap<String, PublicKey>();
        this.readFromModel(model, keys);
        return keys;
    }

    private PublicKey readFromModel(Model model, String keyUri) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        HashMap<String, PublicKey> keys = new HashMap<String, PublicKey>();
        Resource keyRes = model.createResource(keyUri);
        this.readFromModel(model, keys, keyRes);
        return (PublicKey)keys.get(keyUri);
    }

    private void readFromModel(Model model, Map<String, PublicKey> keys) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        this.readFromModel(model, keys, null);
    }

    private void readFromModel(Model model, Map<String, PublicKey> keys, Resource keyAgent) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        StmtIterator keyStmts = model.listStatements(keyAgent, CERT.KEY, RdfUtils.EMPTY_RDF_NODE);
        if (keyStmts.hasNext()) {
            RDFNode eccKeyObj;
            StmtIterator eccPubKeyStmts;
            Statement statement = (Statement)keyStmts.next();
            keyAgent = statement.getSubject();
            RDFNode keyObj = statement.getObject();
            NodeIterator ni = model.listObjectsOfProperty(keyObj.asResource(), CERT.PUBLIC_KEY);
            if (ni.hasNext() && (eccPubKeyStmts = model.listStatements((eccKeyObj = ni.next()).asResource(), RDF.type, (RDFNode)WON.ECCPublicKey)).hasNext()) {
                ni = model.listObjectsOfProperty(eccKeyObj.asResource(), WON.ecc_algorithm);
                if (!ni.hasNext()) {
                    return;
                }
                String algName = ni.next().asLiteral().toString();
                ni = model.listObjectsOfProperty(eccKeyObj.asResource(), WON.ecc_curveId);
                if (!ni.hasNext()) {
                    return;
                }
                String curveId = ni.next().asLiteral().toString();
                ni = model.listObjectsOfProperty(eccKeyObj.asResource(), WON.ecc_qx);
                if (!ni.hasNext()) {
                    return;
                }
                String qx = ni.next().asLiteral().toString();
                ni = model.listObjectsOfProperty(eccKeyObj.asResource(), WON.ecc_qy);
                if (!ni.hasNext()) {
                    return;
                }
                String qy = ni.next().asLiteral().toString();
                ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)curveId);
                ECPoint ecPoint = ecSpec.getCurve().createPoint(new BigInteger(qx, 16), new BigInteger(qy, 16));
                ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)ecSpec);
                KeyFactory keyFactory = KeyFactory.getInstance(algName, "BC");
                PublicKey key = keyFactory.generatePublic((KeySpec)pubKeySpec);
                keys.put(keyAgent.getURI(), key);
            }
        }
    }

    public Set<String> readKeyReferences(Dataset dataset) {
        List keyRefs = RdfUtils.visitFlattenedToList((Dataset)dataset, model -> {
            StmtIterator it = model.listStatements((Resource)null, WONMSG.signer, (RDFNode)null);
            ArrayList<String> ret = new ArrayList<String>();
            while (it.hasNext()) {
                ret.add(((Statement)it.next()).getObject().toString());
            }
            return ret;
        });
        return new HashSet<String>(keyRefs);
    }

    private void writeToModel(Model model, Resource keySubject, WonEccPublicKey pubKey) {
        Resource bn = model.createResource();
        Statement stmt = model.createStatement(bn, RDF.type, (RDFNode)WON.ECCPublicKey);
        model.add(stmt);
        stmt = model.createStatement(bn, WON.ecc_algorithm, pubKey.getAlgorithm());
        model.add(stmt);
        stmt = model.createStatement(bn, WON.ecc_curveId, pubKey.getCurveId());
        model.add(stmt);
        stmt = model.createStatement(bn, WON.ecc_qx, (RDFNode)model.createLiteral(pubKey.getQx()));
        model.add(stmt);
        stmt = model.createStatement(bn, WON.ecc_qy, (RDFNode)model.createLiteral(pubKey.getQy()));
        model.add(stmt);
        Resource bn2 = model.createResource();
        stmt = model.createStatement(bn2, CERT.PUBLIC_KEY, (RDFNode)bn);
        model.add(stmt);
        stmt = model.createStatement(keySubject, CERT.KEY, (RDFNode)bn2);
        model.add(stmt);
    }

    public Model writeToModel(Resource keySubject, WonEccPublicKey pubKey) {
        Objects.requireNonNull(keySubject);
        Objects.requireNonNull(pubKey);
        Model model = ModelFactory.createDefaultModel();
        this.writeToModel(model, keySubject, pubKey);
        return model;
    }

    public void writeToModel(Model model, Resource keySubject, PublicKey publicKey) throws NotSupportedException, KeyNotSupportedException {
        Objects.requireNonNull(keySubject);
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(model);
        KeyInformationExtractorBouncyCastle info = new KeyInformationExtractorBouncyCastle();
        this.writeToModel(model, keySubject, new WonEccPublicKey(info.getCurveID((Key)publicKey), info.getAlgorithm((Key)publicKey), info.getQX(publicKey), info.getQY(publicKey)));
    }
}

