/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import de.uni_koblenz.aggrimm.icp.crypto.sign.algorithm.SignatureAlgorithmInterface;
import de.uni_koblenz.aggrimm.icp.crypto.sign.algorithm.algorithm.SignatureAlgorithmFisteus2010;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.GraphCollection;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.SignatureData;
import io.ipfs.multihash.Multihash;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.rdfsign.ModelConverter;
import won.cryptography.rdfsign.exception.WonMessageHashingException;

public class WonHasher {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ENV_HASH_ALGORITHM = "sha-256";
    public static final Multihash.Type MULTIHASH_TYPE = Multihash.Type.sha3_256;
    private static GenericObjectPool<SignatureAlgorithmInterface> signatureAlgorithmPool = new GenericObjectPool((PooledObjectFactory)new SignatureAlgorithmFactory());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureData hashNamedGraphForSigning(GraphCollection inputWithOneNamedGraph) throws Exception {
        SignatureAlgorithmFisteus2010 algorithm = new SignatureAlgorithmFisteus2010();
        try {
            algorithm.canonicalize(inputWithOneNamedGraph);
            algorithm.postCanonicalize(inputWithOneNamedGraph);
            algorithm.hash(inputWithOneNamedGraph, ENV_HASH_ALGORITHM);
            algorithm.postHash(inputWithOneNamedGraph);
            inputWithOneNamedGraph.getSignature().getDigestGen().reset();
            SignatureData signatureData = inputWithOneNamedGraph.getSignature();
            return signatureData;
        }
        finally {
            if (algorithm != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String calculateHashIdForDataset(Dataset dataset) throws Exception {
        SignatureAlgorithmFisteus2010 algorithm = new SignatureAlgorithmFisteus2010();
        try {
            GraphCollection graphCollection = ModelConverter.fromDataset(dataset);
            algorithm.canonicalize(graphCollection);
            algorithm.postCanonicalize(graphCollection);
            algorithm.hash(graphCollection, ENV_HASH_ALGORITHM);
            algorithm.postHash(graphCollection);
            graphCollection.getSignature().getDigestGen().reset();
            String string = WonHasher.hashToString(graphCollection.getSignature().getHash());
            return string;
        }
        finally {
            if (algorithm != null) {
                // empty if block
            }
        }
    }

    static String hashToString(BigInteger hash) {
        return WonHasher.hashToString(hash.toByteArray());
    }

    static String hashToString(byte[] data) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(ENV_HASH_ALGORITHM, "BC");
        }
        catch (Exception e) {
            throw new WonMessageHashingException("Error computing hash", e);
        }
        byte[] hashed = md.digest(data);
        Multihash multiHash = new Multihash(MULTIHASH_TYPE, hashed);
        return multiHash.toBase58();
    }

    static boolean verify(String expected, BigInteger valueToHash) {
        return WonHasher.verify(expected, valueToHash.toByteArray());
    }

    static boolean verify(String expected, byte[] valueToHash) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(ENV_HASH_ALGORITHM, "BC");
        }
        catch (Exception e) {
            throw new WonMessageHashingException("Error verifying hash", e);
        }
        byte[] hashed = md.digest(valueToHash);
        Multihash multihash = Multihash.fromBase58((String)expected);
        return Arrays.equals(hashed, multihash.getHash());
    }

    static {
        signatureAlgorithmPool.setMaxTotal(20);
    }

    public static class SignatureAlgorithmFactory
    extends BasePooledObjectFactory<SignatureAlgorithmInterface> {
        public SignatureAlgorithmInterface create() throws Exception {
            return new SignatureAlgorithmFisteus2010();
        }

        public PooledObject<SignatureAlgorithmInterface> wrap(SignatureAlgorithmInterface obj) {
            return new DefaultPooledObject((Object)obj);
        }
    }
}

