/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import won.protocol.message.WonMessage;
import won.protocol.message.WonSignatureData;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonRdfUtils;
import won.protocol.vocabulary.WONMSG;

public class SigningStage {
    private String envUri = null;
    private final Set<String> contentUris = new HashSet<String>();
    private final Map<String, String> contentUriToContainingItEnvUri = new HashMap<String, String>();
    private final Map<String, String> envUriToContainedInItEnvUri = new HashMap<String, String>();
    private final Map<String, String> graphUriToSigUri = new HashMap<String, String>();
    private final Map<String, WonSignatureData> sigUriToSigReference = new HashMap<String, WonSignatureData>();
    private final List<String> envOrderedByContainment = new ArrayList<String>();
    private String messageUri;
    private final Map<String, String> graphUriToItsMessageUri = new HashMap<String, String>();
    private String outermostSignatureUri = null;

    public SigningStage(WonMessage message) {
        this.extractData(message);
    }

    public String getMessageUri() {
        return this.messageUri;
    }

    public String getMessageUri(String envelopeGraphUri) {
        return this.graphUriToItsMessageUri.get(envelopeGraphUri);
    }

    private void extractData(WonMessage message) {
        this.messageUri = message.getMessageURI().toString();
        Dataset dataset = message.getCompleteDataset();
        String envelopeURI = message.getEnvelopeURI().toString();
        Model envelope = dataset.getNamedModel(envelopeURI.toString());
        this.extractEnvelopeData(envelopeURI.toString(), envelope, message);
        for (String uri : RdfUtils.getModelNames((Dataset)dataset)) {
            if (envelopeURI.equals(uri)) continue;
            this.extractContentData(uri);
        }
    }

    private void extractContentData(String uri) {
        this.contentUris.add(uri);
    }

    private void extractSignatureData(String sigGraphUri, Model model) {
        WonSignatureData wonSignatureData = WonRdfUtils.SignatureUtils.extractWonSignatureData((String)sigGraphUri, (Model)model);
        if (wonSignatureData != null && wonSignatureData.getSignatureValue() != null) {
            wonSignatureData.getSignedGraphUris().forEach(signed -> this.graphUriToSigUri.put((String)signed, sigGraphUri));
            this.sigUriToSigReference.put(sigGraphUri, wonSignatureData);
        }
    }

    public String getEnvelopeUri() {
        Objects.requireNonNull(this.envUri);
        return this.envUri;
    }

    private void extractEnvelopeData(String envelopeGraphUri, Model envelopeGraph, WonMessage message) {
        this.envUri = envelopeGraphUri;
        String envMessageUri = message.getMessageURIRequired().toString();
        this.graphUriToItsMessageUri.put(envelopeGraphUri, envMessageUri);
        Resource msgEventResource = envelopeGraph.getResource(envMessageUri);
        Resource msgEnvelopeResource = envelopeGraph.getResource(envelopeGraphUri);
        StmtIterator it = msgEventResource.listProperties(WONMSG.content);
        while (it.hasNext()) {
            this.contentUriToContainingItEnvUri.put(it.nextStatement().getObject().asResource().getURI(), envelopeGraphUri);
        }
        it = msgEnvelopeResource.listProperties(WONMSG.containsSignature);
        while (it.hasNext()) {
            Resource refObj = ((Statement)it.next()).getObject().asResource();
            this.extractSignatureData(refObj.getURI(), refObj.getModel());
        }
    }

    public Set<String> getUnsignedContentUris() {
        return this.getUnsignedUris(this.contentUris);
    }

    private Set<String> getUnsignedUris(Set<String> fromUris) {
        HashSet<String> unsigned = new HashSet<String>(fromUris.size());
        for (String uri : fromUris) {
            if (this.graphUriToSigUri.containsKey(uri)) continue;
            unsigned.add(uri);
        }
        return unsigned;
    }

    public String getEnvelopeUriContainingContent(String contentUri) {
        return this.contentUriToContainingItEnvUri.get(contentUri);
    }

    public WonSignatureData getOutermostSignature() {
        return this.sigUriToSigReference.get(this.outermostSignatureUri);
    }
}

