/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import won.protocol.message.WonSignatureData;

public class SignatureVerificationState {
    private Boolean verificationPassed = null;
    private String message = "";
    private final Map<String, List<String>> signedGraphNameToSignatureGraphName = new LinkedHashMap<String, List<String>>();
    private final Map<String, Boolean> signatureGraphNameToVerified = new HashMap<String, Boolean>();
    private final Map<String, List<String>> signatureGraphNameToSignedGraphName = new HashMap<String, List<String>>();
    private final Map<String, String> signatureGraphNameToSignatureValue = new HashMap<String, String>();
    private final List<WonSignatureData> signatures = new ArrayList<WonSignatureData>();

    public void addSignedGraphName(String signedGraphName) {
        if (!this.signedGraphNameToSignatureGraphName.containsKey(signedGraphName)) {
            this.signedGraphNameToSignatureGraphName.put(signedGraphName, new ArrayList());
        }
    }

    public void addSignatureData(WonSignatureData wonSignatureData) {
        this.signatures.add(wonSignatureData);
        for (String signed : wonSignatureData.getSignedGraphUris()) {
            List<String> sigs = this.signedGraphNameToSignatureGraphName.get(signed);
            if (sigs == null) {
                sigs = new ArrayList<String>();
            }
            sigs.add(wonSignatureData.getSignatureUri());
            this.signedGraphNameToSignatureGraphName.put(signed, sigs);
        }
        this.signatureGraphNameToSignedGraphName.put(wonSignatureData.getSignatureUri(), wonSignatureData.getSignedGraphUris());
        this.signatureGraphNameToSignatureValue.put(wonSignatureData.getSignatureUri(), wonSignatureData.getSignatureValue());
    }

    public boolean isVerificationPassed() {
        if (this.verificationPassed != null) {
            return this.verificationPassed;
        }
        for (String signedName : this.signedGraphNameToSignatureGraphName.keySet()) {
            if (this.signedGraphNameToSignatureGraphName.get(signedName).size() >= 1) continue;
            this.verificationPassed = false;
            this.message = "No signatures found for " + signedName;
            return this.verificationPassed;
        }
        this.verificationPassed = true;
        return this.verificationPassed;
    }

    public void setVerificationFailed(String signatureGraphName, String message) {
        this.signatureGraphNameToVerified.put(signatureGraphName, false);
        this.message = message;
        this.verificationPassed = false;
    }

    public void verificationFailed(String message) {
        this.message = message;
        this.verificationPassed = false;
    }

    public String getMessage() {
        return this.message;
    }

    public List<WonSignatureData> getSignatures() {
        return this.signatures;
    }

    public Set<String> getSignatureGraphNames() {
        return this.signatureGraphNameToSignatureValue.keySet();
    }

    public List<String> getSignedGraphNames(String signatureGraphName) {
        return this.signatureGraphNameToSignedGraphName.get(signatureGraphName);
    }
}

