/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.GraphCollection;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.NamedGraph;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.Prefix;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.Triple;
import de.uni_koblenz.aggrimm.icp.crypto.sign.trigplus.TriGPlusWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;

public class ModelConverter {
    public static Model namedGraphToModel(String graphName, GraphCollection gc) throws Exception {
        NamedGraph graph = null;
        for (NamedGraph g : gc.getGraphs()) {
            if (!g.getName().equals(graphName)) continue;
            graph = g;
            break;
        }
        return ModelConverter.namedGraphToModel(graph, gc.getPrefixes());
    }

    public static GraphCollection modelToGraphCollection(String modelURI, Dataset dataset) {
        Model model = dataset.getNamedModel(modelURI);
        return ModelConverter.modelToGraphCollection(modelURI, model);
    }

    public static GraphCollection modelsToGraphCollection(Dataset dataset, String ... modelURIs) {
        GraphCollection graphc = new GraphCollection();
        for (int i = 0; i < modelURIs.length; ++i) {
            String name = modelURIs[i];
            Model model = dataset.getNamedModel(name);
            if (model == null) {
                throw new IllegalArgumentException("No model named '" + name + "' found in dataset");
            }
            graphc.addGraph(ModelConverter.fromModel(name, model));
        }
        return graphc;
    }

    private static Model namedGraphToModel(NamedGraph graph, List<Prefix> prefixes) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
        String dfPref = "";
        for (Prefix p : prefixes) {
            writer.write(p.toString());
            if (!p.getPrefix().equals(":")) continue;
            dfPref = p.getIriContent();
        }
        TriGPlusWriter.writeGraph((BufferedWriter)writer, (NamedGraph)graph, (int)3);
        writer.close();
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        Dataset dataset = DatasetFactory.createGeneral();
        RDFDataMgr.read((Dataset)dataset, (InputStream)is, (Lang)RDFFormat.TRIG.getLang());
        String modelName = ModelConverter.graphNameToModelName(graph.getName(), dfPref);
        Model model = dataset.getNamedModel(modelName);
        for (Prefix pref : prefixes) {
            model.setNsPrefix(pref.getPrefix().replace(":", ""), pref.getIriContent());
        }
        return model;
    }

    private static String graphNameToModelName(String graphName, String dfPref) {
        if (graphName.startsWith("<")) {
            return graphName.substring(1, graphName.length() - 1);
        }
        return dfPref + graphName.replace(":", "");
    }

    public static GraphCollection fromDataset(Dataset dataset) {
        GraphCollection graphc = new GraphCollection();
        String name = null;
        Iterator namesIt = dataset.listNames();
        while (namesIt.hasNext()) {
            name = (String)namesIt.next();
            graphc.addGraph(ModelConverter.fromModel(name, dataset.getNamedModel(name)));
        }
        return graphc;
    }

    private static GraphCollection modelToGraphCollection(String name, Model model) {
        GraphCollection graphc = new GraphCollection();
        NamedGraph namedGraph = ModelConverter.fromModel(name, model);
        graphc.addGraph(namedGraph);
        return graphc;
    }

    public static NamedGraph fromModel(String name, Model model) {
        NamedGraph namedGraph = new NamedGraph(ModelConverter.enclose(name, "<", ">"), 0, null);
        StmtIterator iterator = model.listStatements();
        while (iterator.hasNext()) {
            Statement stmt = iterator.nextStatement();
            String subjString = ModelConverter.rdfNodeAsString((RDFNode)stmt.getSubject());
            String objString = ModelConverter.rdfNodeAsString(stmt.getObject());
            String predString = ModelConverter.enclose(stmt.getPredicate().asResource().getURI(), "<", ">");
            Triple gcTriple = new Triple(subjString, predString, objString);
            namedGraph.addTriple(gcTriple);
        }
        return namedGraph;
    }

    private static String rdfNodeAsString(RDFNode rdfNode) {
        String result;
        if (rdfNode.isURIResource()) {
            String uri = rdfNode.asResource().getURI();
            result = ModelConverter.enclose(uri, "<", ">");
        } else if (rdfNode.isLiteral()) {
            result = ModelConverter.enclose(rdfNode.asLiteral().getLexicalForm(), "\"", "\"");
            if (rdfNode.asLiteral().getDatatypeURI() != null) {
                result = ModelConverter.enclose(result, "", "^^<" + rdfNode.asLiteral().getDatatypeURI() + ">");
            } else if (rdfNode.asLiteral().getLanguage() != null && !rdfNode.asLiteral().getLanguage().isEmpty()) {
                result = ModelConverter.enclose(result, "", "@" + rdfNode.asLiteral().getLanguage());
            }
        } else if (rdfNode.isAnon()) {
            result = ModelConverter.enclose(rdfNode.asResource().getId().getLabelString(), "_:", "");
        } else {
            throw new UnsupportedOperationException("support missing for converting: " + rdfNode.toString());
        }
        return result;
    }

    private static String enclose(String string, String start, String end) {
        return start + string + end;
    }
}

