/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.activemq;

import java.lang.invoke.MethodHandles;
import java.security.cert.X509Certificate;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ConsumerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.ssl.AliasFromFingerprintGenerator;
import won.cryptography.ssl.AliasGenerator;

public class CertificateCheckingBrokerFilter
extends BrokerFilter {
    private final String queueNamePrefixToCheck;
    private final AliasGenerator aliasGenerator = new AliasFromFingerprintGenerator();
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public CertificateCheckingBrokerFilter(Broker next, String queueNamePrefixToCheck) {
        super(next);
        this.queueNamePrefixToCheck = queueNamePrefixToCheck;
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        assert (info != null) : "ConsumerInfo must not be null";
        assert (context != null) : "ConnectionContext must not be null";
        if (this.shouldCheck(info)) {
            boolean checkPassed;
            try {
                checkPassed = this.isOwnerAllowedToConsume(context, info);
            }
            catch (Exception e) {
                throw new SecurityException("could not perform access control check for consumer " + info.getConsumerId() + " and destination " + info.getDestination());
            }
            if (!checkPassed) {
                throw new SecurityException("consumer " + info.getConsumerId() + " not allowed to consume from destination " + info.getDestination());
            }
        }
        logger.debug("consumer added. destination: {}, consumerId: {}", (Object)info.getDestination(), (Object)info.getConsumerId());
        return super.addConsumer(context, info);
    }

    private boolean isOwnerAllowedToConsume(ConnectionContext context, ConsumerInfo info) {
        logger.debug("checking if consumer {} is allowed to consume {} ", (Object)info.getConsumerId(), (Object)info.getDestination());
        if (context.getConnectionState().getInfo().getTransportContext() instanceof X509Certificate[]) {
            X509Certificate ownerCert = ((X509Certificate[])context.getConnectionState().getInfo().getTransportContext())[0];
            String certificateDigest = null;
            try {
                certificateDigest = this.aliasGenerator.generateAlias(ownerCert);
                logger.debug("digest value of certificate: {}", (Object)certificateDigest);
            }
            catch (Exception e) {
                new IllegalArgumentException("Could not calculate sha-1 of owner certificate", e);
            }
            String forOwnerId = info.getDestination().getPhysicalName().substring(this.queueNamePrefixToCheck.length());
            logger.debug("owner id suffix of queue name: {}", (Object)forOwnerId);
            if (certificateDigest.equals(forOwnerId)) {
                logger.debug("allowing to consume");
                return true;
            }
            logger.info("denying message consumption to owner as public key hash does not equal owner id");
            return false;
        }
        logger.info("denying message consumption to owner transportContext is not an X.509 certificate");
        return false;
    }

    private boolean shouldCheck(ConsumerInfo info) {
        return info.getDestination().getPhysicalName().indexOf(this.queueNamePrefixToCheck) == 0;
    }
}

