/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.impl;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import won.cryptography.rdfsign.SignatureVerificationState;
import won.cryptography.rdfsign.SigningStage;
import won.cryptography.rdfsign.WonSigner;
import won.cryptography.rdfsign.WonVerifier;
import won.protocol.message.WonMessage;
import won.protocol.message.WonSignatureData;
import won.protocol.util.WonRdfUtils;
import won.protocol.vocabulary.WONMSG;

public class WonMessageSignerVerifier {
    public static WonMessage sign(PrivateKey privateKey, PublicKey publicKey, String privateKeyUri, WonMessage message) throws Exception {
        Dataset msgDataset = message.getCompleteDataset();
        SigningStage sigStage = new SigningStage(message);
        WonMessageSignerVerifier.addUnreferencedSigReferences(msgDataset, sigStage);
        WonSigner signer = new WonSigner(msgDataset);
        WonMessageSignerVerifier.signContents(msgDataset, sigStage, signer, privateKey, privateKeyUri, publicKey);
        WonMessageSignerVerifier.signEnvelopes(msgDataset, sigStage, signer, privateKey, privateKeyUri, publicKey);
        return new WonMessage(msgDataset);
    }

    private static void signEnvelopes(Dataset msgDataset, SigningStage sigStage, WonSigner signer, PrivateKey privateKey, String privateKeyUri, PublicKey publicKey) throws Exception {
        List<String> envUris = sigStage.getUnsignedEnvUrisOrderedByContainment();
        WonSignatureData wonSignatureData = null;
        String outerEnvUri = null;
        for (String envUri : sigStage.getUnsignedEnvUrisOrderedByContainment()) {
            if (wonSignatureData != null) {
                WonMessageSignerVerifier.addSignature(wonSignatureData, envUri, msgDataset, true);
            }
            wonSignatureData = signer.sign(privateKey, privateKeyUri, publicKey, envUri).get(0);
            outerEnvUri = envUri;
        }
        msgDataset.addNamedModel(wonSignatureData.getSignatureUri(), ModelFactory.createDefaultModel());
        WonMessageSignerVerifier.addSignature(wonSignatureData, wonSignatureData.getSignatureUri(), msgDataset, false);
    }

    public static void addSignature(WonSignatureData sigData, String graphUri, Dataset msgDataset, boolean graphIsEnvelope) {
        Model envelopeGraph = msgDataset.getNamedModel(graphUri);
        Resource envelopeResource = envelopeGraph.createResource(graphUri);
        Resource sigNode = envelopeGraph.createResource(sigData.getSignatureUri());
        if (graphIsEnvelope) {
            envelopeResource.addProperty(WONMSG.CONTAINS_SIGNATURE_PROPERTY, (RDFNode)sigNode);
        }
        WonRdfUtils.SignatureUtils.addSignature((Resource)sigNode, (WonSignatureData)sigData);
    }

    private static void signContents(Dataset msgDataset, SigningStage sigStage, WonSigner signer, PrivateKey privateKey, String privateKeyUri, PublicKey publicKey) throws Exception {
        List<WonSignatureData> sigRefs = signer.sign(privateKey, privateKeyUri, publicKey, sigStage.getUnsignedContentUris());
        for (WonSignatureData sigRef : sigRefs) {
            String envUri = sigStage.getEnvelopeUriContainingContent(sigRef.getSignedGraphUri());
            WonMessageSignerVerifier.addSignature(sigRef, envUri, msgDataset, true);
        }
    }

    private static void addUnreferencedSigReferences(Dataset msgDataset, SigningStage sigStage) {
        String innemostUnsignedEnvUri = null;
        List<String> envUris = sigStage.getUnsignedEnvUrisOrderedByContainment();
        if (envUris.isEmpty()) {
            return;
        }
        innemostUnsignedEnvUri = envUris.get(0);
        WonSignatureData sigRef = sigStage.getOutermostSignature();
        if (sigRef != null) {
            WonMessageSignerVerifier.addSignature(sigRef, innemostUnsignedEnvUri, msgDataset, true);
            msgDataset.removeNamedModel(sigRef.getSignatureUri());
        }
    }

    public static SignatureVerificationState verify(Map<String, PublicKey> keys, WonMessage message) throws Exception {
        Dataset dataset = message.getCompleteDataset();
        WonVerifier verifier = new WonVerifier(dataset);
        verifier.verify(keys);
        return verifier.getVerificationResult();
    }
}

