/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.impl;

import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.cryptography.rdfsign.SignatureVerificationState;
import won.cryptography.rdfsign.WonKeysReaderWriter;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.message.processor.impl.WonMessageSignerVerifier;
import won.protocol.util.RdfUtils;
import won.protocol.util.linkeddata.LinkedDataSource;

public class SignatureCheckingWonMessageProcessor
implements WonMessageProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private LinkedDataSource linkedDataSource;

    public void setLinkedDataSource(LinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }

    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        SignatureVerificationState result = null;
        try {
            Map<String, PublicKey> keys = this.getRequiredPublicKeys(message.getCompleteDataset());
            result = WonMessageSignerVerifier.verify(keys, message);
            this.logger.debug("VERIFIED=" + result.isVerificationPassed() + " with keys: " + keys.values() + " for\n" + RdfUtils.writeDatasetToString((Dataset)message.getCompleteDataset(), (Lang)Lang.TRIG));
        }
        catch (Exception e) {
            throw new WonMessageProcessingException("Could not verify message " + message.getMessageURI(), (Throwable)e);
        }
        if (!result.isVerificationPassed()) {
            throw new WonMessageProcessingException((Throwable)new SignatureException("Could not verify message " + message.getMessageURI() + ": " + result.getMessage()));
        }
        return message;
    }

    private Map<String, PublicKey> getRequiredPublicKeys(Dataset msgDataset) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        WonKeysReaderWriter keyReader = new WonKeysReaderWriter();
        Map<String, PublicKey> keys = keyReader.readFromDataset(msgDataset);
        Set<String> refKeys = keyReader.readKeyReferences(msgDataset);
        for (String refKey : refKeys) {
            Dataset keyDataset;
            Set<PublicKey> resolvedKeys;
            Iterator<PublicKey> iterator;
            if (keys.containsKey(refKey) || !(iterator = (resolvedKeys = keyReader.readFromDataset(keyDataset = this.linkedDataSource.getDataForResource(URI.create(refKey)), refKey)).iterator()).hasNext()) continue;
            PublicKey resolvedKey = iterator.next();
            keys.put(refKey, resolvedKey);
        }
        return keys;
    }
}

