/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.impl;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.jena.riot.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.keymanagement.KeyPairAliasDerivationStrategy;
import won.cryptography.service.CryptographyService;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageEncoder;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.message.processor.impl.WonMessageSignerVerifier;

public class SignatureAddingWonMessageProcessor
implements WonMessageProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CryptographyService cryptographyService;
    private KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy;

    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        PrivateKey privateKey = this.cryptographyService.getDefaultPrivateKey();
        String webId = this.cryptographyService.getDefaultPrivateKeyAlias();
        PublicKey publicKey = this.cryptographyService.getPublicKey(webId);
        try {
            return this.processWithKey(message, webId, privateKey, publicKey);
        }
        catch (Exception e) {
            this.logger.error("Failed to sign", (Throwable)e);
            throw new WonMessageProcessingException("Failed to sign message " + message.getMessageURI().toString());
        }
    }

    public WonMessage processOnBehalfOfNeed(WonMessage message) throws WonMessageProcessingException {
        String alias = this.keyPairAliasDerivationStrategy.getAliasForNeedUri(message.getSenderNeedURI().toString());
        PrivateKey privateKey = this.cryptographyService.getPrivateKey(alias);
        PublicKey publicKey = this.cryptographyService.getPublicKey(alias);
        try {
            return this.processWithKey(message, message.getSenderNeedURI().toString(), privateKey, publicKey);
        }
        catch (Exception e) {
            this.logger.error("Failed to sign", (Throwable)e);
            throw new WonMessageProcessingException("Failed to sign message " + message.getMessageURI().toString());
        }
    }

    private WonMessage processWithKey(WonMessage wonMessage, String privateKeyUri, PrivateKey privateKey, PublicKey publicKey) throws Exception {
        WonMessage signed = WonMessageSignerVerifier.sign(privateKey, publicKey, privateKeyUri, wonMessage);
        this.logger.debug("SIGNED with key " + privateKeyUri + ":\n" + WonMessageEncoder.encode((WonMessage)signed, (Lang)Lang.TRIG));
        return signed;
    }

    public void setCryptographyService(CryptographyService cryptoService) {
        this.cryptographyService = cryptoService;
    }

    public void setKeyPairAliasDerivationStrategy(KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy) {
        this.keyPairAliasDerivationStrategy = keyPairAliasDerivationStrategy;
    }
}

