/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.impl;

import java.security.PublicKey;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.keymanagement.KeyPairAliasDerivationStrategy;
import won.cryptography.rdfsign.WonKeysReaderWriter;
import won.cryptography.service.CryptographyService;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageEncoder;
import won.protocol.message.WonMessageType;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.exception.WonMessageProcessingException;

public class KeyForNewNeedAddingProcessor
implements WonMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(KeyForNewNeedAddingProcessor.class);
    private CryptographyService cryptographyService;
    private KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy;

    public void setCryptographyService(CryptographyService cryptoService) {
        this.cryptographyService = cryptoService;
    }

    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        try {
            if (message.getMessageType() == WonMessageType.CREATE_NEED) {
                String needUri = message.getSenderNeedURI().toString();
                Dataset msgDataset = WonMessageEncoder.encodeAsDataset((WonMessage)message);
                String alias = this.keyPairAliasDerivationStrategy.getAliasForNeedUri(needUri);
                if (this.cryptographyService.getPrivateKey(alias) == null) {
                    this.cryptographyService.createNewKeyPair(alias, alias);
                }
                PublicKey pubKey = this.cryptographyService.getPublicKey(alias);
                WonKeysReaderWriter keyWriter = new WonKeysReaderWriter();
                String contentName = (String)message.getContentGraphURIs().get(0);
                Model contentModel = msgDataset.getNamedModel(contentName);
                keyWriter.writeToModel(contentModel, contentModel.createResource(needUri), pubKey);
                return new WonMessage(msgDataset);
            }
        }
        catch (Exception e) {
            logger.error("Failed to add key", (Throwable)e);
            throw new WonMessageProcessingException("Failed to add key for need in message " + message.getMessageURI().toString());
        }
        return message;
    }

    public void setKeyPairAliasDerivationStrategy(KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy) {
        this.keyPairAliasDerivationStrategy = keyPairAliasDerivationStrategy;
    }
}

