/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.webid;

import java.net.URI;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import won.cryptography.rdfsign.WonKeysReaderWriter;
import won.protocol.util.linkeddata.LinkedDataSource;

public class WebIDVerificationAgent {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LinkedDataSource linkedDataSource;

    public boolean verify(PublicKey publicKey, URI webId) {
        Dataset dataset = null;
        try {
            dataset = this.linkedDataSource.getDataForResource(webId);
        }
        catch (Exception e) {
            throw new InternalAuthenticationServiceException("Could not retrieve data for WebID '" + webId + "'", (Throwable)e);
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            WonKeysReaderWriter ecKeyReader = new WonKeysReaderWriter();
            Set<PublicKey> keys = null;
            try {
                keys = ecKeyReader.readFromDataset(dataset, webId.toString());
            }
            catch (Exception e) {
                throw new InternalAuthenticationServiceException("Could not verify key", (Throwable)e);
            }
            for (PublicKey key : keys) {
                ECPublicKey ecPublicKeyFetched = (ECPublicKey)key;
                if (!ecPublicKey.getW().getAffineX().equals(ecPublicKeyFetched.getW().getAffineX()) || !ecPublicKey.getW().getAffineY().equals(ecPublicKeyFetched.getW().getAffineY())) continue;
                return true;
            }
        } else {
            throw new InternalAuthenticationServiceException("Key type " + publicKey.getAlgorithm() + " not supported");
        }
        return false;
    }

    public List<String> verify(PublicKey publicKey, List<URI> webIDs) throws AuthenticationException {
        ArrayList<String> verified = new ArrayList<String>();
        for (URI webID : webIDs) {
            if (!this.verify(publicKey, webID)) continue;
            verified.add(webID.toString());
        }
        return verified;
    }

    public void setLinkedDataSource(LinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }
}

