/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.webid;

import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.service.CertificateService;
import won.cryptography.webid.WebIDVerificationAgent;
import won.protocol.util.linkeddata.LinkedDataSource;

public class TrustWebIdStrategy
implements TrustStrategy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private WebIDVerificationAgent verificationAgent = new WebIDVerificationAgent();

    public TrustWebIdStrategy(LinkedDataSource linkedDataSource) {
        this.verificationAgent.setLinkedDataSource(linkedDataSource);
    }

    public boolean isTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        if (x509Certificates == null || x509Certificates.length < 1) {
            return false;
        }
        X509Certificate cert = x509Certificates[0];
        PublicKey publicKey = cert.getPublicKey();
        List webIDs = null;
        try {
            webIDs = CertificateService.getWebIdFromSubjectAlternativeNames((X509Certificate)cert);
        }
        catch (CertificateParsingException e) {
            this.logger.warn("error extracting WebIDs from subject alternative names", (Throwable)e);
            return false;
        }
        if (webIDs == null || webIDs.isEmpty()) {
            this.logger.warn("no WebIDs found in subject alternative names");
            return false;
        }
        List<String> verified = null;
        try {
            verified = this.verificationAgent.verify(publicKey, webIDs);
        }
        catch (Exception e) {
            this.logger.warn("Error during WebIDs verification " + webIDs.toString());
            return false;
        }
        if (verified == null || verified.isEmpty()) {
            this.logger.warn("WebIDs do not pass verification " + webIDs.toString());
            return false;
        }
        return true;
    }
}

