/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import de.uni_koblenz.aggrimm.icp.crypto.sign.algorithm.algorithm.SignatureAlgorithmFisteus2010;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.GraphCollection;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Base64;
import java.util.Map;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.rdfsign.ModelConverter;
import won.cryptography.rdfsign.SignatureVerificationState;
import won.protocol.message.WonSignatureData;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonRdfUtils;
import won.protocol.vocabulary.WONMSG;

public class WonVerifier {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Dataset dataset;
    private SignatureVerificationState verificationState = new SignatureVerificationState();

    public WonVerifier(Dataset dataset) {
        BouncyCastleProvider provider = new BouncyCastleProvider();
        this.dataset = dataset;
        this.prepareForVerifying();
    }

    private void prepareForVerifying() {
        for (String graphURI : RdfUtils.getModelNames((Dataset)this.dataset)) {
            Model model;
            if (WonRdfUtils.SignatureUtils.isSignatureGraph((String)graphURI, (Model)(model = this.dataset.getNamedModel(graphURI)))) {
                this.addSignatureToResult(graphURI, model);
                continue;
            }
            this.verificationState.addSignedGraphName(graphURI);
            this.addSignatureReferenceToResult(graphURI, model);
        }
    }

    public SignatureVerificationState getVerificationResult() {
        return this.verificationState;
    }

    public boolean verify(Map<String, PublicKey> publicKeys) throws Exception {
        SignatureAlgorithmFisteus2010 canonicAlgorithm;
        if (this.verificationState.getSignatures().size() == 0) {
            this.verificationState.verificationFailed("No signatures found");
            return this.verificationState.isVerificationPassed();
        }
        if (this.dataset.getDefaultModel().listStatements().hasNext()) {
            this.verificationState.verificationFailed("unsigned data found in default graph");
            return this.verificationState.isVerificationPassed();
        }
        SignatureAlgorithmFisteus2010 hashingAlgorithm = canonicAlgorithm = new SignatureAlgorithmFisteus2010();
        MessageDigest messageDigest = MessageDigest.getInstance("sha-256", "BC");
        for (WonSignatureData wonSignatureData : this.verificationState.getSignatures()) {
            if (!this.dataset.containsNamedModel(wonSignatureData.getSignedGraphUri())) {
                this.logger.debug("cannot verify signature {} as it is not part of this message ", (Object)wonSignatureData.getSignatureUri());
                continue;
            }
            String sigString = wonSignatureData.getSignatureValue();
            if (sigString == null) {
                this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "Failed to compute a signature value " + wonSignatureData.getSignatureUri());
                return this.verificationState.isVerificationPassed();
            }
            if (sigString.length() == 0) {
                this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "Computed an empty signature value " + wonSignatureData.getSignatureUri());
                return this.verificationState.isVerificationPassed();
            }
            PublicKey publicKey = publicKeys.get(wonSignatureData.getVerificationCertificateUri());
            if (publicKey == null) {
                this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "No public key found for " + wonSignatureData.getSignatureUri());
                return this.verificationState.isVerificationPassed();
            }
            String fingerprint = Base64.getEncoder().encodeToString(messageDigest.digest(publicKey.getEncoded()));
            if (!wonSignatureData.getPublicKeyFingerprint().equals(fingerprint)) {
                this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "Fingerprint computed for the specified public key " + wonSignatureData.getVerificationCertificateUri() + " is " + fingerprint + ", which differs from the value found in signature " + wonSignatureData.getSignatureUri());
                return this.verificationState.isVerificationPassed();
            }
            GraphCollection inputGraph = ModelConverter.modelToGraphCollection(wonSignatureData.getSignedGraphUri(), this.dataset);
            canonicAlgorithm.canonicalize(inputGraph);
            canonicAlgorithm.postCanonicalize(inputGraph);
            hashingAlgorithm.hash(inputGraph, "sha-256");
            hashingAlgorithm.postHash(inputGraph);
            BigInteger hashValue = inputGraph.getSignature().getHash();
            String hashString = Base64.getEncoder().encodeToString(hashValue.toByteArray());
            if (!wonSignatureData.getHash().equals(hashString)) {
                this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "Computed hash value " + hashString + " differs from value " + wonSignatureData.getHash() + " found in signature " + wonSignatureData.getSignatureUri());
                if (this.logger.isDebugEnabled()) {
                    StringWriter sw = new StringWriter();
                    RDFDataMgr.write((StringWriter)sw, (Model)this.dataset.getNamedModel(wonSignatureData.getSignedGraphUri()), (Lang)Lang.TRIG);
                    this.logger.debug("wrong signature hash for graph {} with content: {}", (Object)wonSignatureData.getSignedGraphUri(), (Object)sw.toString());
                }
                return this.verificationState.isVerificationPassed();
            }
            Signature sig = Signature.getInstance("NONEwithECDSA", "BC");
            sig.initVerify(publicKey);
            sig.update(hashValue.toByteArray());
            byte[] sigBytes = Base64.getDecoder().decode(sigString);
            if (sig.verify(sigBytes)) continue;
            this.verificationState.setVerificationFailed(wonSignatureData.getSignatureUri(), "Failed to verify " + wonSignatureData.getSignatureUri() + " with public key " + wonSignatureData.getVerificationCertificateUri());
            return this.verificationState.isVerificationPassed();
        }
        return this.verificationState.isVerificationPassed();
    }

    private void addSignatureToResult(String graphUri, Model model) {
        WonSignatureData wonSignatureData = WonRdfUtils.SignatureUtils.extractWonSignatureData((String)graphUri, (Model)model);
        if (wonSignatureData != null && wonSignatureData.getSignatureValue() != null) {
            this.verificationState.addSignatureData(wonSignatureData);
        }
    }

    private void addSignatureReferenceToResult(String graphURI, Model model) {
        RDFNode tempNode = null;
        StmtIterator si = model.listStatements(null, WONMSG.CONTAINS_SIGNATURE_PROPERTY, tempNode);
        while (si.hasNext()) {
            WonSignatureData sigRef = WonRdfUtils.SignatureUtils.extractWonSignatureData((Resource)si.nextStatement().getObject().asResource());
            this.verificationState.addSignatureData(sigRef);
        }
    }
}

