/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import de.uni_koblenz.aggrimm.icp.crypto.sign.algorithm.SignatureAlgorithmInterface;
import de.uni_koblenz.aggrimm.icp.crypto.sign.algorithm.algorithm.SignatureAlgorithmFisteus2010;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.GraphCollection;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.SignatureData;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.RDF;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.rdfsign.ModelConverter;
import won.protocol.message.WonSignatureData;
import won.protocol.vocabulary.SFSIG;

public class WonSigner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SIGNING_ALGORITHM_NAME = "NONEwithECDSA";
    public static final String SIGNING_ALGORITHM_PROVIDER = "BC";
    public static final String ENV_HASH_ALGORITHM = "sha-256";
    private SignatureAlgorithmInterface algorithm;
    private Dataset dataset;
    public static final Model defaultGraphSigningMethod = ModelFactory.createDefaultModel();

    public WonSigner(Dataset dataset) {
        this.dataset = dataset;
        this.algorithm = new SignatureAlgorithmFisteus2010();
        BouncyCastleProvider provider = new BouncyCastleProvider();
    }

    public List<WonSignatureData> sign(PrivateKey privateKey, String cert, PublicKey publicKey, String ... graphsToSign) throws Exception {
        ArrayList<WonSignatureData> sigRefs = new ArrayList<WonSignatureData>(graphsToSign.length);
        MessageDigest md = MessageDigest.getInstance(ENV_HASH_ALGORITHM, SIGNING_ALGORITHM_PROVIDER);
        String fingerprint = Base64.getEncoder().encodeToString(md.digest(publicKey.getEncoded()));
        for (String signedGraphUri : graphsToSign) {
            if (this.logger.isDebugEnabled()) {
                StringWriter sw = new StringWriter();
                RDFDataMgr.write((StringWriter)sw, (Model)this.dataset.getNamedModel(signedGraphUri), (Lang)Lang.TRIG);
                this.logger.debug("signing graph {} with content: {}", (Object)graphsToSign, (Object)sw.toString());
            }
            String signatureUri = signedGraphUri + "-sig";
            GraphCollection inputGraph = ModelConverter.modelToGraphCollection(signedGraphUri, this.dataset);
            SignatureData sigValue = this.signNamedGraph(inputGraph, privateKey, cert);
            String hash = new String(Base64.getEncoder().encodeToString(sigValue.getHash().toByteArray()));
            WonSignatureData sigRef = new WonSignatureData(signedGraphUri, signatureUri, sigValue.getSignature(), hash, fingerprint, cert);
            sigRefs.add(sigRef);
        }
        return sigRefs;
    }

    public List<WonSignatureData> sign(PrivateKey privateKey, String cert, PublicKey publicKey, Collection<String> graphsToSign) throws Exception {
        String[] array = new String[graphsToSign.size()];
        return this.sign(privateKey, cert, publicKey, graphsToSign.toArray(array));
    }

    private SignatureData signNamedGraph(GraphCollection inputWithOneNamedGraph, PrivateKey privateKey, String cert) throws Exception {
        this.algorithm.canonicalize(inputWithOneNamedGraph);
        this.algorithm.postCanonicalize(inputWithOneNamedGraph);
        this.algorithm.hash(inputWithOneNamedGraph, ENV_HASH_ALGORITHM);
        this.algorithm.postHash(inputWithOneNamedGraph);
        return this.sign(inputWithOneNamedGraph, privateKey, cert);
    }

    private SignatureData sign(GraphCollection gc, PrivateKey privateKey, String verificationCertificate) throws Exception {
        verificationCertificate = verificationCertificate == null ? "\"cert\"" : "<" + verificationCertificate + ">";
        if (!gc.hasSignature()) {
            throw new Exception("GraphCollection has no signature data. Call 'canonicalize' and 'hash' methods first.");
        }
        SignatureData sigData = gc.getSignature();
        Signature sig = Signature.getInstance(SIGNING_ALGORITHM_NAME, SIGNING_ALGORITHM_PROVIDER);
        sig.initSign(privateKey);
        sig.update(sigData.getHash().toByteArray());
        byte[] signatureBytes = sig.sign();
        String signature = Base64.getEncoder().encodeToString(signatureBytes);
        sigData.setSignature(signature);
        sigData.setSignatureMethod(privateKey.getAlgorithm().toLowerCase());
        sigData.setVerificationCertificate(verificationCertificate);
        return sigData;
    }

    static {
        Resource bNode = defaultGraphSigningMethod.createResource();
        bNode.addProperty(RDF.type, (RDFNode)SFSIG.GRAPH_SIGNING_METHOD);
        bNode.addProperty(SFSIG.HAS_DIGEST_METHOD, (RDFNode)SFSIG.DIGEST_METHOD_SHA_256);
        bNode.addProperty(SFSIG.HAS_GRAPH_CANONICALIZATION_METHOD, (RDFNode)SFSIG.GRAPH_CANONICALIZATION_METHOD_Fisteus2010);
        bNode.addProperty(SFSIG.HAS_GRAPH_DIGEST_METHOD, (RDFNode)SFSIG.GRAPH_DIGEST_METHOD_Fisteus2010);
        bNode.addProperty(SFSIG.HAS_GRAPH_SERIALIZATION_METHOD, (RDFNode)SFSIG.GRAPH_SERIALIZATION_METHOD_TRIG);
        bNode.addProperty(SFSIG.HAS_SIGNATURE_METHOD, (RDFNode)SFSIG.SIGNATURE_METHOD_ECDSA);
    }
}

