/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import de.uni_koblenz.aggrimm.icp.crypto.sign.ontology.Ontology;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.NotSupportedException;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.exception.KeyNotSupportedException;
import won.cryptography.key.KeyInformationExtractorBouncyCastle;
import won.cryptography.rdfsign.WonEccPublicKey;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.CERT;
import won.protocol.vocabulary.WONCRYPT;

public class WonKeysReaderWriter {
    private static final Logger logger = LoggerFactory.getLogger(WonKeysReaderWriter.class);

    public Map<String, PublicKey> readFromDataset(Dataset dataset) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        HashMap<String, PublicKey> keys = new HashMap<String, PublicKey>();
        this.readFromModel(dataset.getDefaultModel(), keys);
        for (String name : RdfUtils.getModelNames((Dataset)dataset)) {
            this.readFromModel(dataset.getNamedModel(name), keys);
        }
        return keys;
    }

    public Set<PublicKey> readFromDataset(Dataset dataset, String keyUri) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        PublicKey key = this.readFromModel(dataset.getDefaultModel(), keyUri);
        HashSet<PublicKey> keys = new HashSet<PublicKey>();
        if (key != null) {
            keys.add(key);
        }
        for (String name : RdfUtils.getModelNames((Dataset)dataset)) {
            key = this.readFromModel(dataset.getNamedModel(name), keyUri);
            if (key == null) continue;
            keys.add(key);
        }
        return keys;
    }

    public Map<String, PublicKey> readFromModel(Model model) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        HashMap<String, PublicKey> keys = new HashMap<String, PublicKey>();
        this.readFromModel(model, keys);
        return keys;
    }

    public PublicKey readFromModel(Model model, String keyUri) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        HashMap<String, PublicKey> keys = new HashMap<String, PublicKey>();
        Resource keyRes = model.createResource(keyUri);
        this.readFromModel(model, keys, keyRes);
        return (PublicKey)keys.get(keyUri);
    }

    private void readFromModel(Model model, Map<String, PublicKey> keys) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        this.readFromModel(model, keys, null);
    }

    private void readFromModel(Model model, Map<String, PublicKey> keys, Resource keyAgent) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        StmtIterator keyStmts = model.listStatements(keyAgent, CERT.KEY, RdfUtils.EMPTY_RDF_NODE);
        if (keyStmts.hasNext()) {
            RDFNode eccKeyObj;
            StmtIterator eccPubKeyStmts;
            Statement statement = (Statement)keyStmts.next();
            keyAgent = statement.getSubject();
            RDFNode keyObj = statement.getObject();
            NodeIterator ni = model.listObjectsOfProperty(keyObj.asResource(), CERT.PUBLIC_KEY);
            if (ni.hasNext() && (eccPubKeyStmts = model.listStatements((eccKeyObj = ni.next()).asResource(), RDF.type, (RDFNode)WONCRYPT.ECC_PUBLIC_KEY)).hasNext()) {
                ni = model.listObjectsOfProperty(eccKeyObj.asResource(), WONCRYPT.ECC_ALGORITHM);
                String algName = null;
                String curveId = null;
                String qx = null;
                String qy = null;
                if (!ni.hasNext()) {
                    return;
                }
                algName = ni.next().asLiteral().toString();
                ni = model.listObjectsOfProperty(eccKeyObj.asResource(), WONCRYPT.ECC_CURVE_ID);
                if (!ni.hasNext()) {
                    return;
                }
                curveId = ni.next().asLiteral().toString();
                ni = model.listObjectsOfProperty(eccKeyObj.asResource(), WONCRYPT.ECC_QX);
                if (!ni.hasNext()) {
                    return;
                }
                qx = ni.next().asLiteral().toString();
                ni = model.listObjectsOfProperty(eccKeyObj.asResource(), WONCRYPT.ECC_QY);
                if (!ni.hasNext()) {
                    return;
                }
                qy = ni.next().asLiteral().toString();
                ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)curveId);
                ECPoint ecPoint = ecSpec.getCurve().createPoint(new BigInteger(qx, 16), new BigInteger(qy, 16));
                ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)ecSpec);
                KeyFactory keyFactory = KeyFactory.getInstance(algName, "BC");
                PublicKey key = keyFactory.generatePublic((KeySpec)pubKeySpec);
                keys.put(keyAgent.getURI(), key);
            }
        }
    }

    public Set<String> readKeyReferences(Dataset dataset) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        HashSet<String> keyRefs = new HashSet<String>();
        for (String name : RdfUtils.getModelNames((Dataset)dataset)) {
            this.readKeyReferences(dataset.getNamedModel(name), keyRefs);
        }
        return keyRefs;
    }

    public void readKeyReferences(Model model, Set<String> keyRefs) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        Property typeProp = model.createProperty(Ontology.getSigIri(), "hasVerificationCertificate");
        StmtIterator si = model.listStatements(null, typeProp, RdfUtils.EMPTY_RDF_NODE);
        if (si.hasNext()) {
            keyRefs.add(((Statement)si.next()).getObject().asResource().getURI());
        }
    }

    public void writeToModel(Model model, Resource keySubject, WonEccPublicKey pubKey) {
        Resource bn = model.createResource();
        Statement stmt = model.createStatement(bn, RDF.type, (RDFNode)WONCRYPT.ECC_PUBLIC_KEY);
        model.add(stmt);
        stmt = model.createStatement(bn, WONCRYPT.ECC_ALGORITHM, pubKey.getAlgorithm());
        model.add(stmt);
        stmt = model.createStatement(bn, WONCRYPT.ECC_CURVE_ID, pubKey.getCurveId());
        model.add(stmt);
        stmt = model.createStatement(bn, WONCRYPT.ECC_QX, (RDFNode)model.createLiteral(pubKey.getQx()));
        model.add(stmt);
        stmt = model.createStatement(bn, WONCRYPT.ECC_QY, (RDFNode)model.createLiteral(pubKey.getQy()));
        model.add(stmt);
        Resource bn2 = model.createResource();
        stmt = model.createStatement(bn2, CERT.PUBLIC_KEY, (RDFNode)bn);
        model.add(stmt);
        stmt = model.createStatement(keySubject, CERT.KEY, (RDFNode)bn2);
        model.add(stmt);
    }

    public Model writeToModel(Resource keySubject, WonEccPublicKey pubKey) {
        Model model = ModelFactory.createDefaultModel();
        this.writeToModel(model, keySubject, pubKey);
        return model;
    }

    public void writeToModel(Model model, Resource keySubject, PublicKey publicKey) throws NotSupportedException, KeyNotSupportedException {
        if (!(publicKey instanceof ECPublicKey)) {
            throw new NotSupportedException("Not supported key: " + publicKey.getClass().getName());
        }
        KeyInformationExtractorBouncyCastle info = new KeyInformationExtractorBouncyCastle();
        this.writeToModel(model, keySubject, new WonEccPublicKey(info.getCurveID((Key)publicKey), info.getAlgorithm((Key)publicKey), info.getQX(publicKey), info.getQY(publicKey)));
    }
}

