/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.GraphCollection;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.NamedGraph;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.Prefix;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.SignatureData;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.Triple;
import de.uni_koblenz.aggrimm.icp.crypto.sign.ontology.Ontology;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import won.cryptography.rdfsign.ModelConverter;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonRdfUtils;
import won.protocol.vocabulary.WONMSG;

public class WonAssembler {
    private static final String SIG_GRAPH_NAME_TEMP = "<http://localhost:8080/won/SIG-GRAPH-PLACEHOLDER-TEMP>";
    private static final String SIG_BNODE_NAME = "_:sig-1";

    @Deprecated
    public static void assemble(GraphCollection namedSignedGraph, Dataset graphOrigin) throws Exception {
        Ontology o = WonAssembler.prepareSignatureOntology(namedSignedGraph);
        WonAssembler.verifyGraphCollectionContainsExactlyOneNamedGraph(namedSignedGraph);
        WonAssembler.addSignatureTriplesToOrigin(namedSignedGraph, o, graphOrigin);
    }

    public static void assemble(GraphCollection namedSignedGraph, Dataset graphOrigin, String sigGraphURI) throws Exception {
        Ontology o = WonAssembler.prepareSignatureOntology(namedSignedGraph);
        WonAssembler.verifyGraphCollectionContainsExactlyOneNamedGraph(namedSignedGraph);
        WonAssembler.addSignatureAsNamedGraphToOrigin(namedSignedGraph, o, graphOrigin, sigGraphURI);
    }

    public static void removeSignatureGraphs(Dataset dataset) {
        for (String name : RdfUtils.getModelNames((Dataset)dataset)) {
            if (!WonRdfUtils.SignatureUtils.isSignatureGraph((String)name, (Model)dataset.getNamedModel(name))) continue;
            dataset.removeNamedModel(name);
        }
    }

    private static void verifyGraphCollectionContainsExactlyOneNamedGraph(GraphCollection gc) {
        LinkedList graphs = gc.getGraphs();
        if (!(graphs.size() == 1 && !((NamedGraph)graphs.get(0)).getName().isEmpty() || graphs.size() == 2 && ((NamedGraph)graphs.get(0)).getName().isEmpty() || ((NamedGraph)graphs.get(1)).getName().isEmpty())) {
            throw new IllegalArgumentException(WonAssembler.class.getName() + " expects exactly one named graph, found " + (graphs.size() - 1));
        }
    }

    private static Ontology prepareSignatureOntology(GraphCollection gc) {
        SignatureData sigData = gc.getSignature();
        Ontology o = new Ontology(sigData);
        String sigPrefix = o.getSigPrefix();
        String sigIri = Ontology.getSigIri();
        String sigPre = sigPrefix;
        int prefixCounter = 2;
        while (true) {
            boolean prefixUsed = false;
            for (Prefix p : gc.getPrefixes()) {
                if (!p.getPrefix().equals(sigPre) || p.getIri().equals("<" + sigIri + ">")) continue;
                prefixUsed = true;
                break;
            }
            if (!prefixUsed) break;
            sigPre = sigPrefix + prefixCounter;
            ++prefixCounter;
        }
        o.setSigPrefix(sigPre);
        return o;
    }

    private static NamedGraph getSignatureAsGraph(GraphCollection gc, Ontology o) {
        gc.addPrefix(new Prefix(o.getSigPrefix() + ":", "<" + Ontology.getSigIri() + ">"));
        String name = ((NamedGraph)gc.getGraphs().get(0)).getName();
        if (name.isEmpty()) {
            name = ((NamedGraph)gc.getGraphs().get(1)).getName();
        }
        NamedGraph sigGraph = new NamedGraph(SIG_GRAPH_NAME_TEMP, 0, null);
        ArrayList sigGraphTriples = sigGraph.getTriples();
        sigGraphTriples.add(new Triple(SIG_BNODE_NAME, "<" + WONMSG.HAS_SIGNED_GRAPH_PROPERTY + ">", name));
        for (Triple t : o.getTriples()) {
            String subj = t.getSubject();
            sigGraphTriples.add(new Triple(subj, t.getPredicate(), t.getObject()));
        }
        gc.addGraph(sigGraph);
        return sigGraph;
    }

    private static NamedGraph getSignatureAsGraph(GraphCollection gc, String sigGraphURI, Ontology o) {
        gc.addPrefix(new Prefix(o.getSigPrefix() + ":", "<" + Ontology.getSigIri() + ">"));
        String name = ((NamedGraph)gc.getGraphs().get(0)).getName();
        if (name.isEmpty()) {
            name = ((NamedGraph)gc.getGraphs().get(1)).getName();
        }
        NamedGraph sigGraph = new NamedGraph(SIG_GRAPH_NAME_TEMP, 0, null);
        ArrayList sigGraphTriples = sigGraph.getTriples();
        sigGraphTriples.add(new Triple("<" + sigGraphURI + ">", "<" + WONMSG.HAS_SIGNED_GRAPH_PROPERTY + ">", name));
        for (Triple t : o.getTriples()) {
            String subj = t.getSubject();
            if (subj.equals(SIG_BNODE_NAME)) {
                subj = "<" + sigGraphURI + ">";
            }
            sigGraphTriples.add(new Triple(subj, t.getPredicate(), t.getObject()));
        }
        gc.addGraph(sigGraph);
        return sigGraph;
    }

    private static void addSignatureAsNamedGraphToOrigin(GraphCollection namedSignedGraph, Ontology o, Dataset graphOrigin, String sigGraphURI) throws Exception {
        NamedGraph signatureAsGraph = WonAssembler.getSignatureAsGraph(namedSignedGraph, sigGraphURI, o);
        Model signatureAsModel = ModelConverter.namedGraphToModel(signatureAsGraph.getName(), namedSignedGraph);
        graphOrigin.addNamedModel(sigGraphURI, signatureAsModel);
        WonAssembler.addPrefixesToDefaultGraph(signatureAsModel, graphOrigin);
    }

    private static void addSignatureTriplesToOrigin(GraphCollection namedSignedGraph, Ontology o, Dataset graphOrigin) throws Exception {
        NamedGraph signatureAsGraph = WonAssembler.getSignatureAsGraph(namedSignedGraph, o);
        Model signatureAsModel = ModelConverter.namedGraphToModel(signatureAsGraph.getName(), namedSignedGraph);
        graphOrigin.getDefaultModel().add(signatureAsModel);
        WonAssembler.addPrefixesToDefaultGraph(signatureAsModel, graphOrigin);
    }

    private static void addPrefixesToDefaultGraph(Model signatureAsModel, Dataset graphOrigin) {
        for (String prefix : signatureAsModel.getNsPrefixMap().keySet()) {
            graphOrigin.getDefaultModel().setNsPrefix(prefix, (String)signatureAsModel.getNsPrefixMap().get(prefix));
        }
        graphOrigin.getDefaultModel().getNsPrefixMap().putAll(signatureAsModel.getNsPrefixMap());
    }
}

