/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import won.protocol.message.WonMessage;
import won.protocol.message.WonSignatureData;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonRdfUtils;
import won.protocol.vocabulary.RDFG;
import won.protocol.vocabulary.WONMSG;

public class SigningStage {
    private Set<String> envUris = new HashSet<String>();
    private Set<String> contentUris = new HashSet<String>();
    private Map<String, String> contentUriToContainingItEnvUri = new HashMap<String, String>();
    private Map<String, String> envUriToContainedInItEnvUri = new HashMap<String, String>();
    private Map<String, String> graphUriToSigUri = new HashMap<String, String>();
    private Map<String, WonSignatureData> sigUriToSigReference = new HashMap<String, WonSignatureData>();
    private List<String> envOrderedByContainment = new ArrayList<String>();
    private String messageUri;
    private Map<String, String> graphUriToItsMessageUri = new HashMap<String, String>();
    private String outermostSignatureUri = null;

    public SigningStage(WonMessage message) {
        this.extractData(message);
    }

    public String getMessageUri() {
        return this.messageUri;
    }

    public String getMessageUri(String envelopeGraphUri) {
        return this.graphUriToItsMessageUri.get(envelopeGraphUri);
    }

    private void extractData(WonMessage message) {
        this.messageUri = message.getMessageURI().toString();
        Dataset dataset = message.getCompleteDataset();
        for (String uri : RdfUtils.getModelNames((Dataset)dataset)) {
            Model model;
            if (message.isEnvelopeGraph(uri, model = dataset.getNamedModel(uri))) {
                this.extractEnvelopeData(uri, model, message);
                continue;
            }
            if (WonRdfUtils.SignatureUtils.isSignature((Model)model, (String)uri)) {
                if (this.outermostSignatureUri != null) {
                    throw new IllegalStateException("Found more than one signature graph");
                }
                this.outermostSignatureUri = uri;
                this.extractSignatureData(uri, model);
                continue;
            }
            this.extractContentData(uri);
        }
        this.orderEnvelopes(message);
    }

    private void orderEnvelopes(WonMessage message) {
        String outer = message.getOuterEnvelopeGraphURI().toString();
        this.envOrderedByContainment.add(outer);
        while (outer != null) {
            String inner = this.envUriToContainedInItEnvUri.get(outer);
            if (inner != null) {
                this.envOrderedByContainment.add(0, inner);
            }
            outer = inner;
        }
    }

    private void extractContentData(String uri) {
        this.contentUris.add(uri);
    }

    private void extractSignatureData(String uri, Model model) {
        WonSignatureData wonSignatureData = WonRdfUtils.SignatureUtils.extractWonSignatureData((String)uri, (Model)model);
        if (wonSignatureData != null && wonSignatureData.getSignatureValue() != null) {
            this.graphUriToSigUri.put(wonSignatureData.getSignedGraphUri(), uri);
            this.sigUriToSigReference.put(uri, wonSignatureData);
        }
    }

    private void extractEnvelopeData(String envelopeGraphUri, Model envelopeGraph, WonMessage message) {
        this.envUris.add(envelopeGraphUri);
        String envMessageUri = RdfUtils.findOnePropertyFromResource((Model)envelopeGraph, (Resource)envelopeGraph.getResource(envelopeGraphUri), (Property)RDFG.SUBGRAPH_OF).asResource().getURI();
        this.graphUriToItsMessageUri.put(envelopeGraphUri, envMessageUri);
        Resource msgEventResource = envelopeGraph.getResource(envMessageUri);
        Resource msgEnvelopeResource = envelopeGraph.getResource(envelopeGraphUri);
        StmtIterator it = msgEventResource.listProperties(WONMSG.HAS_CONTENT_PROPERTY);
        while (it.hasNext()) {
            this.contentUriToContainingItEnvUri.put(it.nextStatement().getObject().asResource().getURI(), envelopeGraphUri);
        }
        it = msgEnvelopeResource.listProperties(WONMSG.CONTAINS_ENVELOPE);
        if (it.hasNext()) {
            this.envUriToContainedInItEnvUri.put(envelopeGraphUri, it.nextStatement().getObject().asResource().getURI());
        }
        it = msgEnvelopeResource.listProperties(WONMSG.CONTAINS_SIGNATURE_PROPERTY);
        while (it.hasNext()) {
            Resource refObj = ((Statement)it.next()).getObject().asResource();
            this.extractSignatureData(refObj.getURI(), refObj.getModel());
        }
    }

    public List<String> getUnsignedEnvUrisOrderedByContainment() {
        ArrayList<String> ordered = new ArrayList<String>(this.envOrderedByContainment.size());
        for (String uri : this.envOrderedByContainment) {
            if (this.graphUriToSigUri.containsKey(uri)) continue;
            ordered.add(uri);
        }
        return ordered;
    }

    public Set<String> getUnsignedContentUris() {
        return this.getUnsignedUris(this.contentUris);
    }

    private Set<String> getUnsignedUris(Set<String> fromUris) {
        HashSet<String> unsigned = new HashSet<String>(fromUris.size());
        for (String uri : fromUris) {
            if (this.graphUriToSigUri.containsKey(uri)) continue;
            unsigned.add(uri);
        }
        return unsigned;
    }

    public String getEnvelopeUriContainingContent(String contentUri) {
        return this.contentUriToContainingItEnvUri.get(contentUri);
    }

    public WonSignatureData getOutermostSignature() {
        return this.sigUriToSigReference.get(this.outermostSignatureUri);
    }
}

