/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.message.WonSignatureData;

public class SignatureVerificationState {
    private Boolean verificationPassed = null;
    private String message = "";
    private Map<String, List<String>> signedGraphNameToSignatureGraphName = new LinkedHashMap<String, List<String>>();
    private Map<String, Boolean> signatureGraphNameToVerified = new HashMap<String, Boolean>();
    private Map<String, String> signatureGraphNameToSignedGraphName = new HashMap<String, String>();
    private Map<String, String> signatureGraphNameToSignatureValue = new HashMap<String, String>();
    private List<WonSignatureData> signatures = new ArrayList<WonSignatureData>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addSignedGraphName(String signedGraphName) {
        if (!this.signedGraphNameToSignatureGraphName.containsKey(signedGraphName)) {
            this.signedGraphNameToSignatureGraphName.put(signedGraphName, new ArrayList());
        }
    }

    public void addSignatureData(WonSignatureData wonSignatureData) {
        this.signatures.add(wonSignatureData);
        if (!this.signedGraphNameToSignatureGraphName.containsKey(wonSignatureData.getSignedGraphUri())) {
            this.signedGraphNameToSignatureGraphName.put(wonSignatureData.getSignedGraphUri(), new ArrayList());
        }
        this.signatureGraphNameToSignedGraphName.put(wonSignatureData.getSignatureUri(), wonSignatureData.getSignedGraphUri());
        this.signedGraphNameToSignatureGraphName.get(wonSignatureData.getSignedGraphUri()).add(wonSignatureData.getSignatureUri());
        this.signatureGraphNameToSignatureValue.put(wonSignatureData.getSignatureUri(), wonSignatureData.getSignatureValue());
    }

    public boolean isVerificationPassed() {
        if (this.verificationPassed != null) {
            return this.verificationPassed;
        }
        for (String signedName : this.signedGraphNameToSignatureGraphName.keySet()) {
            if (this.signedGraphNameToSignatureGraphName.get(signedName).size() >= 1) continue;
            this.verificationPassed = false;
            this.message = "No signatures found for " + signedName;
            return this.verificationPassed;
        }
        this.verificationPassed = true;
        return this.verificationPassed;
    }

    public void setVerificationFailed(String signatureGraphName, String message) {
        this.signatureGraphNameToVerified.put(signatureGraphName, false);
        this.message = message;
        this.verificationPassed = false;
    }

    public void verificationFailed(String message) {
        this.message = message;
        this.verificationPassed = false;
    }

    public String getMessage() {
        return this.message;
    }

    public List<WonSignatureData> getSignatures() {
        return this.signatures;
    }

    public Set<String> getSignatureGraphNames() {
        return this.signatureGraphNameToSignatureValue.keySet();
    }

    public String getSignedGraphName(String signatureGraphName) {
        return this.signatureGraphNameToSignedGraphName.get(signatureGraphName);
    }
}

