/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.rdfsign;

import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.GraphCollection;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.NamedGraph;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.Prefix;
import de.uni_koblenz.aggrimm.icp.crypto.sign.graph.Triple;
import de.uni_koblenz.aggrimm.icp.crypto.sign.trigplus.TriGPlusWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;

public class ModelConverter {
    public static Model namedGraphToModel(String graphName, GraphCollection gc) throws Exception {
        NamedGraph graph = null;
        for (NamedGraph g : gc.getGraphs()) {
            if (!g.getName().equals(graphName)) continue;
            graph = g;
            break;
        }
        return ModelConverter.namedGraphToModel(graph, gc.getPrefixes());
    }

    public static GraphCollection modelToGraphCollection(String modelURI, Dataset modelDataset) {
        Map pm = modelDataset.getDefaultModel().getNsPrefixMap();
        Model model = modelDataset.getNamedModel(modelURI);
        return ModelConverter.modelToGraphCollection(modelURI, model, pm);
    }

    private static Model namedGraphToModel(NamedGraph graph, List<Prefix> prefixes) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
        String dfPref = "";
        for (Prefix p : prefixes) {
            writer.write(p.toString());
            if (!p.getPrefix().equals(":")) continue;
            dfPref = p.getIriContent();
        }
        TriGPlusWriter.writeGraph((BufferedWriter)writer, (NamedGraph)graph, (int)3);
        writer.close();
        String content = os.toString();
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        Dataset dataset = DatasetFactory.createGeneral();
        RDFDataMgr.read((Dataset)dataset, (InputStream)is, (Lang)RDFFormat.TRIG.getLang());
        String modelName = ModelConverter.graphNameToModelName(graph.getName(), dfPref);
        Model model = dataset.getNamedModel(modelName);
        for (Prefix pref : prefixes) {
            model.setNsPrefix(pref.getPrefix().replace(":", ""), pref.getIriContent());
        }
        return model;
    }

    private static String graphNameToModelName(String graphName, String dfPref) {
        if (graphName.startsWith("<")) {
            return graphName.substring(1, graphName.length() - 1);
        }
        return dfPref + graphName.replace(":", "");
    }

    private static GraphCollection modelToGraphCollection(String name, Model model, Map<String, String> pm) {
        GraphCollection graphc = new GraphCollection();
        NamedGraph namedGraph = new NamedGraph(ModelConverter.enclose(name, "<", ">"), 0, null);
        StmtIterator iterator = model.listStatements();
        while (iterator.hasNext()) {
            Statement stmt = iterator.nextStatement();
            String subjString = ModelConverter.rdfNodeAsString((RDFNode)stmt.getSubject());
            String objString = ModelConverter.rdfNodeAsString(stmt.getObject());
            String predString = ModelConverter.enclose(stmt.getPredicate().asResource().getURI(), "<", ">");
            Triple gcTriple = new Triple(subjString, predString, objString);
            namedGraph.addTriple(gcTriple);
        }
        graphc.addGraph(namedGraph);
        for (String prefix : pm.keySet()) {
            graphc.addPrefix(new Prefix(prefix + ":", "<" + pm.get(prefix) + ">"));
        }
        return graphc;
    }

    private static String rdfNodeAsString(RDFNode rdfNode) {
        String result = null;
        if (rdfNode.isURIResource()) {
            String uri = rdfNode.asResource().getURI();
            result = ModelConverter.enclose(uri, "<", ">");
        } else if (rdfNode.isLiteral()) {
            result = ModelConverter.enclose(rdfNode.asLiteral().getLexicalForm(), "\"", "\"");
            if (rdfNode.asLiteral().getDatatypeURI() != null) {
                result = ModelConverter.enclose(result, "", "^^<" + rdfNode.asLiteral().getDatatypeURI() + ">");
            } else if (rdfNode.asLiteral().getLanguage() != null && !rdfNode.asLiteral().getLanguage().isEmpty()) {
                result = ModelConverter.enclose(result, "", "@" + rdfNode.asLiteral().getLanguage());
            }
        } else if (rdfNode.isAnon()) {
            result = ModelConverter.enclose(rdfNode.asResource().getId().getLabelString(), "_:", "");
        } else {
            throw new UnsupportedOperationException("support missing for converting: " + rdfNode.toString());
        }
        return result;
    }

    private static String enclose(String string, String start, String end) {
        return start + string + end;
    }
}

