/*
 * Decompiled with CFR 0.152.
 */
package won.cryptography.activemq;

import java.security.cert.X509Certificate;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ConsumerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.cryptography.ssl.AliasFromFingerprintGenerator;
import won.cryptography.ssl.AliasGenerator;

public class CertificateCheckingBrokerFilter
extends BrokerFilter {
    private String queueNamePrefixToCheck;
    private AliasGenerator aliasGenerator = new AliasFromFingerprintGenerator();
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public CertificateCheckingBrokerFilter(Broker next, String queueNamePrefixToCheck) {
        super(next);
        this.queueNamePrefixToCheck = queueNamePrefixToCheck;
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        assert (info != null) : "ConsumerInfo must not be null";
        assert (context != null) : "ConnectionContext must not be null";
        if (this.shouldCheck(info)) {
            boolean checkPassed = false;
            try {
                checkPassed = this.isOwnerAllowedToConsume(context, info);
            }
            catch (Exception e) {
                throw new SecurityException("could not perform access control check for consumer " + info.getConsumerId() + " and destination " + info.getDestination());
            }
            if (!checkPassed) {
                throw new SecurityException("consumer " + info.getConsumerId() + " not allowed to consume from destination " + info.getDestination());
            }
        }
        this.logger.debug("consumer added. destination: {}, consumerId: {}", (Object)info.getDestination(), (Object)info.getConsumerId());
        return super.addConsumer(context, info);
    }

    private boolean isOwnerAllowedToConsume(ConnectionContext context, ConsumerInfo info) {
        this.logger.debug("checking if consumer {} is allowed to consume {} ", (Object)info.getConsumerId(), (Object)info.getDestination());
        if (context.getConnectionState().getInfo().getTransportContext() instanceof X509Certificate[]) {
            X509Certificate ownerCert = ((X509Certificate[])context.getConnectionState().getInfo().getTransportContext())[0];
            String certificateDigest = null;
            try {
                certificateDigest = this.aliasGenerator.generateAlias(ownerCert);
                this.logger.debug("digest value of certificate: {}", (Object)certificateDigest);
            }
            catch (Exception e) {
                new IllegalArgumentException("Could not calculate sha-1 of owner certificate", e);
            }
            String forOwnerId = info.getDestination().getPhysicalName().substring(this.queueNamePrefixToCheck.length());
            this.logger.debug("owner id suffix of queue name: {}", (Object)forOwnerId);
            if (certificateDigest.equals(forOwnerId)) {
                this.logger.debug("allowing to consume");
                return true;
            }
            this.logger.info("denying message consumption to owner as public key hash does not equal owner id");
            return false;
        }
        this.logger.info("denying message consumption to owner transportContext is not an X.509 certificate");
        return false;
    }

    private boolean shouldCheck(ConsumerInfo info) {
        return info.getDestination().getPhysicalName().indexOf(this.queueNamePrefixToCheck) == 0;
    }
}

