/*
 * Decompiled with CFR 0.152.
 */
package at.phatbl.shellexec;

import at.phatbl.shellexec.ShellCommandTimeoutException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 22\u00020\u0001:\u00012B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\rH\u0002J\b\u00101\u001a\u00020-H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000f\"\u0004\b\u001f\u0010\u0011R\u0013\u0010 \u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\nR\u0016\u0010\"\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\nR\u0011\u0010$\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001bR\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u00063"}, d2={"Lat/phatbl/shellexec/ShellCommand;", "", "baseDir", "Ljava/io/File;", "command", "", "(Ljava/io/File;Ljava/lang/String;)V", "getBaseDir", "()Ljava/io/File;", "getCommand", "()Ljava/lang/String;", "errorFile", "errorOutput", "Ljava/io/OutputStream;", "getErrorOutput", "()Ljava/io/OutputStream;", "setErrorOutput", "(Ljava/io/OutputStream;)V", "exitValue", "", "getExitValue", "()I", "setExitValue", "(I)V", "failed", "", "getFailed", "()Z", "outputFile", "standardOutput", "getStandardOutput", "setStandardOutput", "stderr", "getStderr", "stdout", "getStdout", "succeeded", "getSucceeded", "timeout", "", "getTimeout", "()J", "setTimeout", "(J)V", "copy", "", "input", "Ljava/io/InputStream;", "output", "start", "Companion", "shellexec"})
public class ShellCommand {
    private long timeout;
    private int exitValue;
    @Nullable
    private OutputStream standardOutput;
    @Nullable
    private OutputStream errorOutput;
    private File outputFile;
    private File errorFile;
    @NotNull
    private final File baseDir;
    @NotNull
    private final String command;
    private static final long defaultTimeout = 1200L;
    public static final int uninitializedExitValue = -999;
    private static final int bufferSize = 0x200000;
    public static final Companion Companion = new Companion(null);

    public final long getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(long l) {
        this.timeout = l;
    }

    public final int getExitValue() {
        return this.exitValue;
    }

    public final void setExitValue(int n) {
        this.exitValue = n;
    }

    public final boolean getSucceeded() {
        return this.exitValue == 0;
    }

    public final boolean getFailed() {
        return !this.getSucceeded();
    }

    @Nullable
    public final OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    public final void setStandardOutput(@Nullable OutputStream outputStream) {
        this.standardOutput = outputStream;
    }

    @Nullable
    public final OutputStream getErrorOutput() {
        return this.errorOutput;
    }

    public final void setErrorOutput(@Nullable OutputStream outputStream) {
        this.errorOutput = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getStdout() {
        String string;
        File file = this.outputFile;
        if (file == null) {
            return null;
        }
        File output = file;
        Object object = output;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileInputStream((File)object3);
        bl3 = false;
        object2 = new InputStreamReader((InputStream)object3, charset);
        bl2 = false;
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl5 = false;
            string = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getStderr() {
        String string;
        File file = this.errorFile;
        if (file == null) {
            return null;
        }
        File errors = file;
        Object object = errors;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileInputStream((File)object3);
        bl3 = false;
        object2 = new InputStreamReader((InputStream)object3, charset);
        bl2 = false;
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl5 = false;
            string = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return string;
    }

    public void start() {
        this.baseDir.mkdirs();
        ProcessBuilder pb = new ProcessBuilder("bash", "-c", this.command).directory(this.baseDir);
        OutputStream outputStream = this.standardOutput;
        OutputStream errorStream = this.errorOutput;
        if (outputStream == null) {
            this.outputFile = FilesKt.createTempFile$default((String)"shellexec-", (String)"-output.log", null, (int)4, null);
            pb.redirectOutput(this.outputFile);
        }
        if (errorStream == null) {
            this.errorFile = FilesKt.createTempFile$default((String)"shellexec-", (String)"-error.log", null, (int)4, null);
            pb.redirectError(this.errorFile);
        }
        Process process = pb.start();
        if (outputStream != null) {
            Process process2 = process;
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"process");
            InputStream inputStream = process2.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.inputStream");
            this.copy(inputStream, outputStream);
        }
        if (errorStream != null) {
            Process process3 = process;
            Intrinsics.checkExpressionValueIsNotNull((Object)process3, (String)"process");
            InputStream inputStream = process3.getErrorStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.errorStream");
            this.copy(inputStream, errorStream);
        }
        try {
            process.waitFor(this.timeout, TimeUnit.SECONDS);
            Process process4 = process;
            Intrinsics.checkExpressionValueIsNotNull((Object)process4, (String)"process");
            if (!process4.isAlive()) {
                this.exitValue = process.exitValue();
            }
        }
        catch (InterruptedException e) {
            String message = "Command timeout, exceeded " + this.timeout + " second limit.";
            throw (Throwable)new ShellCommandTimeoutException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copy(InputStream input, OutputStream output) throws IOException {
        Closeable closeable = input;
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = output;
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                OutputStream it2 = (OutputStream)closeable2;
                boolean bl4 = false;
                byte[] buffer = new byte[0x200000];
                int bytesRead = input.read(buffer);
                while (bytesRead != -1) {
                    output.write(buffer, 0, bytesRead);
                    bytesRead = input.read(buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final File getBaseDir() {
        return this.baseDir;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    public ShellCommand(@NotNull File baseDir, @NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this.baseDir = baseDir;
        this.command = command;
        this.timeout = 1200L;
        this.exitValue = -999;
    }

    public /* synthetic */ ShellCommand(File file, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = new File(".");
        }
        this(file, string);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lat/phatbl/shellexec/ShellCommand$Companion;", "", "()V", "bufferSize", "", "defaultTimeout", "", "uninitializedExitValue", "shellexec"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

