/*
 * Decompiled with CFR 0.152.
 */
package at.phatbl.shellexec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\b\u0018\u0000 A2\u00020\u0001:\u0001AB\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0005H\u00c6\u0003J\u001d\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\fH\u0002J\u0013\u0010:\u001a\u00020\u00182\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010<\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010=\u001a\u000206J\u0010\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u000208H\u0002J\t\u0010@\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0014\"\u0004\b#\u0010\u0016R\u001c\u0010$\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000e\"\u0004\b&\u0010\u0010R\u0011\u0010'\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\nR\u0011\u0010)\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\nR\u0011\u0010+\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001aR\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006B"}, d2={"Lat/phatbl/shellexec/ShellCommand;", "", "baseDir", "Ljava/io/File;", "command", "", "(Ljava/io/File;Ljava/lang/String;)V", "getBaseDir", "()Ljava/io/File;", "getCommand", "()Ljava/lang/String;", "errorOutput", "Ljava/io/OutputStream;", "getErrorOutput", "()Ljava/io/OutputStream;", "setErrorOutput", "(Ljava/io/OutputStream;)V", "exitValue", "", "getExitValue", "()I", "setExitValue", "(I)V", "failed", "", "getFailed", "()Z", "process", "Ljava/lang/Process;", "getProcess", "()Ljava/lang/Process;", "setProcess", "(Ljava/lang/Process;)V", "readLimit", "getReadLimit", "setReadLimit", "standardOutput", "getStandardOutput", "setStandardOutput", "stderr", "getStderr", "stdout", "getStdout", "succeeded", "getSucceeded", "timeout", "", "getTimeout", "()J", "setTimeout", "(J)V", "component1", "component2", "copy", "", "input", "Ljava/io/InputStream;", "output", "equals", "other", "hashCode", "start", "stream2String", "stream", "toString", "Companion", "shellexec"})
public final class ShellCommand {
    @NotNull
    public Process process;
    @Nullable
    private OutputStream standardOutput;
    @Nullable
    private OutputStream errorOutput;
    private int exitValue;
    private int readLimit;
    private long timeout;
    @NotNull
    private final File baseDir;
    @NotNull
    private final String command;
    private static final long defaultTimeout = 1200L;
    private static final int uninitializedExitValue = -999;
    private static final int bufferSize = 0x200000;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Process getProcess() {
        Process process = this.process;
        if (process == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
        }
        return process;
    }

    public final void setProcess(@NotNull Process process) {
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"<set-?>");
        this.process = process;
    }

    @Nullable
    public final OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    public final void setStandardOutput(@Nullable OutputStream outputStream) {
        this.standardOutput = outputStream;
    }

    @Nullable
    public final OutputStream getErrorOutput() {
        return this.errorOutput;
    }

    public final void setErrorOutput(@Nullable OutputStream outputStream) {
        this.errorOutput = outputStream;
    }

    @NotNull
    public final String getStdout() {
        Process process = this.process;
        if (process == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
        }
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.inputStream");
        return this.stream2String(inputStream);
    }

    @NotNull
    public final String getStderr() {
        Process process = this.process;
        if (process == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
        }
        InputStream inputStream = process.getErrorStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.errorStream");
        return this.stream2String(inputStream);
    }

    public final int getExitValue() {
        return this.exitValue;
    }

    public final void setExitValue(int n) {
        this.exitValue = n;
    }

    public final boolean getSucceeded() {
        return this.exitValue == 0;
    }

    public final boolean getFailed() {
        return !this.getSucceeded();
    }

    public final int getReadLimit() {
        return this.readLimit;
    }

    public final void setReadLimit(int n) {
        this.readLimit = n;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(long l) {
        this.timeout = l;
    }

    public final void start() {
        block21: {
            byte[] errorMessage;
            boolean bl;
            Charset charset;
            String string;
            block20: {
                this.baseDir.mkdirs();
                ProcessBuilder pb = new ProcessBuilder("bash", "-c", this.command).directory(this.baseDir);
                Process process = pb.start();
                Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"pb.start()");
                Process process2 = this.process = process;
                if (process2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                }
                process2.getInputStream().mark(this.readLimit);
                Process process3 = this.process;
                if (process3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                }
                process3.getErrorStream().mark(this.readLimit);
                if (this.standardOutput != null) {
                    Process process4 = this.process;
                    if (process4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                    }
                    InputStream inputStream = process4.getInputStream();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.inputStream");
                    OutputStream outputStream = this.standardOutput;
                    if (outputStream == null) {
                        Intrinsics.throwNpe();
                    }
                    this.copy(inputStream, outputStream);
                }
                if (this.errorOutput != null) {
                    Process process5 = this.process;
                    if (process5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                    }
                    InputStream inputStream = process5.getErrorStream();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.errorStream");
                    OutputStream outputStream = this.errorOutput;
                    if (outputStream == null) {
                        Intrinsics.throwNpe();
                    }
                    this.copy(inputStream, outputStream);
                }
                try {
                    Process process6 = this.process;
                    if (process6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                    }
                    process6.getInputStream().reset();
                }
                catch (Exception e) {
                    OutputStream stdout = this.standardOutput;
                    if (stdout == null) break block20;
                    string = "Could not reset input stream. Mark with Readlimit " + this.readLimit + " not found.";
                    charset = Charsets.UTF_8;
                    bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    errorMessage = byArray;
                    stdout.write(errorMessage);
                }
            }
            try {
                Process process = this.process;
                if (process == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                }
                process.getErrorStream().reset();
            }
            catch (Exception e) {
                OutputStream stderr = this.errorOutput;
                if (stderr == null) break block21;
                string = "Could not reset error stream. Mark with Readlimit " + this.readLimit + " not found.";
                charset = Charsets.UTF_8;
                bl = false;
                String string3 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                errorMessage = byArray;
                stderr.write(errorMessage);
            }
        }
        try {
            Process process = this.process;
            if (process == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"process");
            }
            process.waitFor(this.timeout, TimeUnit.SECONDS);
            Process process7 = this.process;
            if (process7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"process");
            }
            this.exitValue = process7.exitValue();
        }
        catch (Exception e) {
            String string = "ShellCommand timeout: " + e;
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    private final String stream2String(InputStream stream) {
        String string;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            String lineSeparator = System.getProperty("line.separator");
            TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(builder, lineSeparator){
                final /* synthetic */ StringBuilder $builder;
                final /* synthetic */ String $lineSeparator;

                public final void invoke(@NotNull String line) {
                    Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
                    this.$builder.append(line);
                    this.$builder.append(this.$lineSeparator);
                }
                {
                    this.$builder = stringBuilder;
                    this.$lineSeparator = string;
                    super(1);
                }
            }));
            String string2 = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.toString()");
            string = string2;
        }
        catch (Exception e) {
            return "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[0x200000];
        int bytesRead = input.read(buffer);
        while (bytesRead != -1) {
            output.write(buffer, 0, bytesRead);
            bytesRead = input.read(buffer);
        }
    }

    @NotNull
    public final File getBaseDir() {
        return this.baseDir;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    public ShellCommand(@NotNull File baseDir, @NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this.baseDir = baseDir;
        this.command = command;
        this.exitValue = -999;
        this.readLimit = 0x200000;
        this.timeout = 1200L;
    }

    public /* synthetic */ ShellCommand(File file, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = new File(".");
        }
        this(file, string);
    }

    @NotNull
    public final File component1() {
        return this.baseDir;
    }

    @NotNull
    public final String component2() {
        return this.command;
    }

    @NotNull
    public final ShellCommand copy(@NotNull File baseDir, @NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        return new ShellCommand(baseDir, command);
    }

    public static /* synthetic */ ShellCommand copy$default(ShellCommand shellCommand, File file, String string, int n, Object object) {
        if ((n & 1) != 0) {
            file = shellCommand.baseDir;
        }
        if ((n & 2) != 0) {
            string = shellCommand.command;
        }
        return shellCommand.copy(file, string);
    }

    @NotNull
    public String toString() {
        return "ShellCommand(baseDir=" + this.baseDir + ", command=" + this.command + ")";
    }

    public int hashCode() {
        File file = this.baseDir;
        String string = this.command;
        return (file != null ? ((Object)file).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ShellCommand)) break block3;
                ShellCommand shellCommand = (ShellCommand)object;
                if (!Intrinsics.areEqual((Object)this.baseDir, (Object)shellCommand.baseDir) || !Intrinsics.areEqual((Object)this.command, (Object)shellCommand.command)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lat/phatbl/shellexec/ShellCommand$Companion;", "", "()V", "bufferSize", "", "defaultTimeout", "", "uninitializedExitValue", "shellexec"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

