/*
 * Decompiled with CFR 0.152.
 */
package at.phatbl.shellexec;

import at.phatbl.shellexec.ShellCommand;
import at.phatbl.shellexec.logging.GradleLogOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u000203H\u0007J\b\u00105\u001a\u000203H\u0016J\b\u00106\u001a\u000203H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00158F@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR*\u0010!\u001a\u0004\u0018\u00010\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0006\"\u0004\b#\u0010\bR*\u0010$\u001a\u0004\u0018\u00010\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0006\"\u0004\b&\u0010\bR\u000e\u0010'\u001a\u00020(X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0013R\u0012\u0010+\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010,\u001a\u00020-8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00068"}, d2={"Lat/phatbl/shellexec/ShellExec;", "Lorg/gradle/api/DefaultTask;", "()V", "command", "", "getCommand", "()Ljava/lang/String;", "setCommand", "(Ljava/lang/String;)V", "environment", "", "", "getEnvironment", "()Ljava/util/Map;", "setEnvironment", "(Ljava/util/Map;)V", "errorOutput", "Ljava/io/OutputStream;", "getErrorOutput", "()Ljava/io/OutputStream;", "exitValue", "", "getExitValue", "()I", "setExitValue", "(I)V", "ignoreExitValue", "", "getIgnoreExitValue", "()Z", "setIgnoreExitValue", "(Z)V", "value", "postPath", "getPostPath", "setPostPath", "prePath", "getPrePath", "setPrePath", "shellCommand", "Lat/phatbl/shellexec/ShellCommand;", "standardOutput", "getStandardOutput", "systemPath", "workingDir", "Ljava/io/File;", "getWorkingDir", "()Ljava/io/File;", "setWorkingDir", "(Ljava/io/File;)V", "buildPath", "", "exec", "postExec", "preExec", "Companion", "at.phatbl.shellexec"})
public class ShellExec
extends DefaultTask {
    @Input
    @NotNull
    private Map<String, Object> environment;
    @InputDirectory
    @NotNull
    private File workingDir;
    @Internal
    @NotNull
    private final OutputStream standardOutput;
    @Internal
    @NotNull
    private final OutputStream errorOutput;
    @Input
    private boolean ignoreExitValue;
    @Internal
    private int exitValue;
    private ShellCommand shellCommand;
    @Input
    @NotNull
    private String command;
    @Input
    private String systemPath;
    @Internal
    @Nullable
    private String prePath;
    @Internal
    @Nullable
    private String postPath;
    private static final String pathAdditions = "./bin:/usr/local/bin";
    private static final String PATH = "PATH";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public final void setEnvironment(@NotNull Map<String, Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.environment = map;
    }

    @NotNull
    public final File getWorkingDir() {
        return this.workingDir;
    }

    public final void setWorkingDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.workingDir = file;
    }

    @NotNull
    public final OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    @NotNull
    public final OutputStream getErrorOutput() {
        return this.errorOutput;
    }

    public final boolean getIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    public final void setIgnoreExitValue(boolean bl) {
        this.ignoreExitValue = bl;
    }

    public final int getExitValue() {
        ShellCommand shellCommand = this.shellCommand;
        if (shellCommand == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellCommand");
        }
        return shellCommand.getExitValue();
    }

    public final void setExitValue(int n) {
        this.exitValue = n;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    public final void setCommand(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.command = string;
    }

    @Nullable
    public final String getPrePath() {
        return this.prePath;
    }

    public final void setPrePath(@Nullable String value) {
        this.prePath = value;
        this.buildPath();
    }

    @Nullable
    public final String getPostPath() {
        return this.postPath;
    }

    public final void setPostPath(@Nullable String value) {
        this.postPath = value;
        this.buildPath();
    }

    @TaskAction
    public final void exec() {
        this.preExec();
        if (Intrinsics.areEqual((Object)this.command, (Object)"")) {
            throw (Throwable)new GradleException("command must not be empty");
        }
        ShellCommand shellCommand = this.shellCommand = new ShellCommand(this.workingDir, this.command);
        if (shellCommand == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellCommand");
        }
        shellCommand.setStandardOutput(this.standardOutput);
        ShellCommand shellCommand2 = this.shellCommand;
        if (shellCommand2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellCommand");
        }
        shellCommand2.setErrorOutput(this.errorOutput);
        ShellCommand shellCommand3 = this.shellCommand;
        if (shellCommand3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellCommand");
        }
        shellCommand3.start();
        ShellCommand shellCommand4 = this.shellCommand;
        if (shellCommand4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellCommand");
        }
        if (shellCommand4.getFailed()) {
            String message = "command failed with exit code " + this.getExitValue();
            if (!this.ignoreExitValue) {
                throw (Throwable)new GradleException(message);
            }
            this.getLogger().error(message);
        }
        this.postExec();
    }

    public void preExec() {
        this.getLogger().debug("No custom logic in preExec");
    }

    public void postExec() {
        this.getLogger().debug("No custom logic in postExec");
    }

    private final void buildPath() {
        String string;
        String path = this.systemPath;
        this.getLogger().info("System.env.PATH: " + this.systemPath);
        String string2 = this.prePath;
        if (string2 != null) {
            String pre = string = string2;
            path = "" + pre + ':' + path;
        }
        String string3 = this.postPath;
        if (string3 != null) {
            String post = string = string3;
            path = "" + path + ':' + post;
        }
        this.environment.put(PATH, path);
        this.getLogger().info("PATH: " + this.environment.get(PATH));
    }

    public ShellExec() {
        Map map;
        ShellExec shellExec = this;
        shellExec.environment = map = (Map)new LinkedHashMap();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        this.workingDir = file;
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        this.standardOutput = (OutputStream)((Object)new GradleLogOutputStream(logger, LogLevel.LIFECYCLE));
        Logger logger2 = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
        this.errorOutput = (OutputStream)((Object)new GradleLogOutputStream(logger2, LogLevel.ERROR));
        this.exitValue = -999;
        this.command = "";
        String string = System.getenv(PATH);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getenv(PATH)");
        this.systemPath = string;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lat/phatbl/shellexec/ShellExec$Companion;", "", "()V", "PATH", "", "pathAdditions", "at.phatbl.shellexec"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

