/*
 * Decompiled with CFR 0.152.
 */
package at.phatbl.shellexec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u000eH\u0003J\u0013\u00102\u001a\u00020\u00192\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00104\u001a\u00020\bH\u00d6\u0001J\u0006\u00105\u001a\u00020.J\u0010\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u000200H\u0002J\t\u00108\u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010\u0012R\u0011\u0010%\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\fR\u0011\u0010'\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\fR\u0011\u0010)\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001b\u00a8\u00069"}, d2={"Lat/phatbl/shellexec/ShellCommand;", "", "baseDir", "Ljava/io/File;", "command", "", "(Ljava/io/File;Ljava/lang/String;)V", "BUFFER_SIZE", "", "getBaseDir", "()Ljava/io/File;", "getCommand", "()Ljava/lang/String;", "errorOutput", "Ljava/io/OutputStream;", "getErrorOutput", "()Ljava/io/OutputStream;", "setErrorOutput", "(Ljava/io/OutputStream;)V", "exitValue", "getExitValue", "()I", "setExitValue", "(I)V", "failed", "", "getFailed", "()Z", "process", "Ljava/lang/Process;", "getProcess", "()Ljava/lang/Process;", "setProcess", "(Ljava/lang/Process;)V", "standardOutput", "getStandardOutput", "setStandardOutput", "stderr", "getStderr", "stdout", "getStdout", "succeeded", "getSucceeded", "component1", "component2", "copy", "", "input", "Ljava/io/InputStream;", "output", "equals", "other", "hashCode", "start", "stream2String", "stream", "toString", "at.phatbl.shellexec"})
public final class ShellCommand {
    @NotNull
    public Process process;
    @Nullable
    private OutputStream standardOutput;
    @Nullable
    private OutputStream errorOutput;
    private int exitValue;
    private final int BUFFER_SIZE = 0x200000;
    @NotNull
    private final File baseDir;
    @NotNull
    private final String command;

    @NotNull
    public final Process getProcess() {
        Process process = this.process;
        if (process == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
        }
        return process;
    }

    public final void setProcess(@NotNull Process process) {
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"<set-?>");
        this.process = process;
    }

    @Nullable
    public final OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    public final void setStandardOutput(@Nullable OutputStream outputStream) {
        this.standardOutput = outputStream;
    }

    @Nullable
    public final OutputStream getErrorOutput() {
        return this.errorOutput;
    }

    public final void setErrorOutput(@Nullable OutputStream outputStream) {
        this.errorOutput = outputStream;
    }

    @NotNull
    public final String getStdout() {
        Process process = this.process;
        if (process == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
        }
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.inputStream");
        return this.stream2String(inputStream);
    }

    @NotNull
    public final String getStderr() {
        Process process = this.process;
        if (process == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
        }
        InputStream inputStream = process.getErrorStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.errorStream");
        return this.stream2String(inputStream);
    }

    public final int getExitValue() {
        return this.exitValue;
    }

    public final void setExitValue(int n) {
        this.exitValue = n;
    }

    public final boolean getSucceeded() {
        return this.exitValue == 0;
    }

    public final boolean getFailed() {
        return !this.getSucceeded();
    }

    public final void start() {
        this.baseDir.mkdir();
        ProcessBuilder pb = new ProcessBuilder("bash", "-c", "cd " + this.baseDir + " && " + this.command);
        Process process = pb.start();
        Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"pb.start()");
        this.process = process;
        if (this.standardOutput != null) {
            Process process2 = this.process;
            if (process2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"process");
            }
            InputStream inputStream = process2.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.inputStream");
            OutputStream outputStream = this.standardOutput;
            if (outputStream == null) {
                Intrinsics.throwNpe();
            }
            this.copy(inputStream, outputStream);
        }
        if (this.errorOutput != null) {
            Process process3 = this.process;
            if (process3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"process");
            }
            InputStream inputStream = process3.getErrorStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.errorStream");
            OutputStream outputStream = this.errorOutput;
            if (outputStream == null) {
                Intrinsics.throwNpe();
            }
            this.copy(inputStream, outputStream);
        }
        Process process4 = this.process;
        if (process4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
        }
        process4.waitFor(1200L, TimeUnit.SECONDS);
        Process process5 = this.process;
        if (process5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
        }
        this.exitValue = process5.exitValue();
    }

    private final String stream2String(InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder builder = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(builder, lineSeparator){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ String $lineSeparator;

            public final void invoke(@NotNull String line) {
                Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
                this.$builder.append(line);
                this.$builder.append(this.$lineSeparator);
            }
            {
                this.$builder = stringBuilder;
                this.$lineSeparator = string;
                super(1);
            }
        }));
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copy(InputStream input, OutputStream output) throws IOException {
        try {
            byte[] buffer = new byte[this.BUFFER_SIZE];
            int bytesRead = input.read(buffer);
            while (bytesRead != -1) {
                output.write(buffer, 0, bytesRead);
                bytesRead = input.read(buffer);
            }
        }
        finally {
            input.close();
            output.close();
        }
    }

    @NotNull
    public final File getBaseDir() {
        return this.baseDir;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    public ShellCommand(@NotNull File baseDir, @NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this.baseDir = baseDir;
        this.command = command;
        this.exitValue = -999;
        this.BUFFER_SIZE = 0x200000;
    }

    @NotNull
    public final File component1() {
        return this.baseDir;
    }

    @NotNull
    public final String component2() {
        return this.command;
    }

    @NotNull
    public final ShellCommand copy(@NotNull File baseDir, @NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        return new ShellCommand(baseDir, command);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ShellCommand copy$default(ShellCommand shellCommand, File file, String string, int n, Object object) {
        if ((n & 1) != 0) {
            file = shellCommand.baseDir;
        }
        if ((n & 2) != 0) {
            string = shellCommand.command;
        }
        return shellCommand.copy(file, string);
    }

    public String toString() {
        return "ShellCommand(baseDir=" + this.baseDir + ", command=" + this.command + ")";
    }

    public int hashCode() {
        File file = this.baseDir;
        String string = this.command;
        return (file != null ? ((Object)file).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ShellCommand)) break block3;
                ShellCommand shellCommand = (ShellCommand)object;
                if (!Intrinsics.areEqual((Object)this.baseDir, (Object)shellCommand.baseDir) || !Intrinsics.areEqual((Object)this.command, (Object)shellCommand.command)) break block3;
            }
            return true;
        }
        return false;
    }
}

