/*
 * Decompiled with CFR 0.152.
 */
package at.phatbl.simple_exec;

import at.phatbl.simple_exec.ShellCommand;
import at.phatbl.simple_exec.logging.GradleLogOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 92\u00020\u0001:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u000207H\u0007R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R(\u0010%\u001a\u0004\u0018\u00010\u00042\b\u0010$\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0006\"\u0004\b'\u0010\bR(\u0010(\u001a\u0004\u0018\u00010\u00042\b\u0010$\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0006\"\u0004\b*\u0010\bR\u000e\u0010+\u001a\u00020,X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0013R\u0012\u0010/\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u0006:"}, d2={"Lat/phatbl/simple_exec/SimpleExec;", "Lorg/gradle/api/DefaultTask;", "()V", "command", "", "getCommand", "()Ljava/lang/String;", "setCommand", "(Ljava/lang/String;)V", "environment", "", "", "getEnvironment", "()Ljava/util/Map;", "setEnvironment", "(Ljava/util/Map;)V", "errorOutput", "Ljava/io/OutputStream;", "getErrorOutput", "()Ljava/io/OutputStream;", "execResult", "Lorg/gradle/process/ExecResult;", "getExecResult", "()Lorg/gradle/process/ExecResult;", "setExecResult", "(Lorg/gradle/process/ExecResult;)V", "exitValue", "", "getExitValue", "()I", "ignoreExitValue", "", "getIgnoreExitValue", "()Z", "setIgnoreExitValue", "(Z)V", "value", "postPath", "getPostPath", "setPostPath", "prePath", "getPrePath", "setPrePath", "shellCommand", "Lat/phatbl/simple_exec/ShellCommand;", "standardOutput", "getStandardOutput", "systemPath", "workingDir", "Ljava/io/File;", "getWorkingDir", "()Ljava/io/File;", "setWorkingDir", "(Ljava/io/File;)V", "buildPath", "", "exec", "Companion", "at.phatbl.simple_exec"})
public class SimpleExec
extends DefaultTask {
    @NotNull
    private Map<String, Object> environment;
    @NotNull
    private File workingDir;
    @NotNull
    private final OutputStream standardOutput;
    @NotNull
    private final OutputStream errorOutput;
    private boolean ignoreExitValue;
    @Nullable
    private ExecResult execResult;
    private ShellCommand shellCommand;
    @Input
    @Nullable
    private String command;
    @Input
    private String systemPath;
    @Nullable
    private String prePath;
    @Nullable
    private String postPath;
    private static final String pathAdditions = "./bin:/usr/local/bin";
    private static final String PATH = "PATH";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public final void setEnvironment(@NotNull Map<String, Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.environment = map;
    }

    @NotNull
    public final File getWorkingDir() {
        return this.workingDir;
    }

    public final void setWorkingDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.workingDir = file;
    }

    @NotNull
    public final OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    @NotNull
    public final OutputStream getErrorOutput() {
        return this.errorOutput;
    }

    public final boolean getIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    public final void setIgnoreExitValue(boolean bl) {
        this.ignoreExitValue = bl;
    }

    @Nullable
    public final ExecResult getExecResult() {
        return this.execResult;
    }

    public final void setExecResult(@Nullable ExecResult execResult) {
        this.execResult = execResult;
    }

    public final int getExitValue() {
        ShellCommand shellCommand = this.shellCommand;
        if (shellCommand == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellCommand");
        }
        return shellCommand.getExitValue();
    }

    @Nullable
    public final String getCommand() {
        return this.command;
    }

    public final void setCommand(@Nullable String string) {
        this.command = string;
    }

    @Nullable
    public final String getPrePath() {
        return this.prePath;
    }

    public final void setPrePath(@Nullable String value) {
        this.prePath = value;
        this.buildPath();
    }

    @Nullable
    public final String getPostPath() {
        return this.postPath;
    }

    public final void setPostPath(@Nullable String value) {
        this.postPath = value;
        this.buildPath();
    }

    @TaskAction
    public final void exec() {
        String string = this.command;
        if (string == null) {
            throw (Throwable)new GradleException("command must be specified");
        }
        String cmd = string;
        if (Intrinsics.areEqual((Object)cmd, (Object)"")) {
            throw (Throwable)new GradleException("command must not be empty");
        }
        ShellCommand shellCommand = this.shellCommand = new ShellCommand(this.workingDir, cmd);
        if (shellCommand == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellCommand");
        }
        shellCommand.setStandardOutput(this.standardOutput);
        ShellCommand shellCommand2 = this.shellCommand;
        if (shellCommand2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellCommand");
        }
        shellCommand2.setErrorOutput(this.errorOutput);
        ShellCommand shellCommand3 = this.shellCommand;
        if (shellCommand3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellCommand");
        }
        shellCommand3.start();
        ShellCommand shellCommand4 = this.shellCommand;
        if (shellCommand4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellCommand");
        }
        if (shellCommand4.getFailed()) {
            String message = "command failed with exit code " + this.getExitValue();
            if (!this.ignoreExitValue) {
                throw (Throwable)new GradleException(message);
            }
            this.getLogger().error(message);
        }
    }

    private final void buildPath() {
        String string;
        String path = this.systemPath;
        this.getLogger().info("System.env.PATH: " + this.systemPath);
        String string2 = this.prePath;
        if (string2 != null) {
            String pre = string = string2;
            path = "" + pre + ':' + path;
        }
        String string3 = this.postPath;
        if (string3 != null) {
            String post = string = string3;
            path = "" + path + ':' + post;
        }
        this.environment.put(PATH, path);
        this.getLogger().info("PATH: " + this.environment.get(PATH));
    }

    public SimpleExec() {
        Map map;
        SimpleExec simpleExec = this;
        simpleExec.environment = map = (Map)new LinkedHashMap();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        this.workingDir = file;
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        this.standardOutput = (OutputStream)((Object)new GradleLogOutputStream(logger, LogLevel.LIFECYCLE));
        Logger logger2 = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
        this.errorOutput = (OutputStream)((Object)new GradleLogOutputStream(logger2, LogLevel.ERROR));
        String string = System.getenv(PATH);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getenv(PATH)");
        this.systemPath = string;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lat/phatbl/simple_exec/SimpleExec$Companion;", "", "()V", "PATH", "", "pathAdditions", "at.phatbl.simple_exec"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

