/*
 * Decompiled with CFR 0.152.
 */
package at.nonblocking.maven.nonsnapshot.impl;

import at.nonblocking.maven.nonsnapshot.PathUtil;
import at.nonblocking.maven.nonsnapshot.ScmHandler;
import at.nonblocking.maven.nonsnapshot.exception.NonSnapshotPluginException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ScmHandler.class, hint="GIT")
public class ScmHandlerGitImpl
implements ScmHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ScmHandlerGitImpl.class);
    private File baseDir;
    private Git git;
    private CredentialsProvider credentialsProvider;
    private boolean doPush = true;

    @Override
    public boolean isWorkingCopy(File path) {
        return this.git != null;
    }

    @Override
    public boolean checkChangesSinceRevision(File moduleDirectory, String revisionId) {
        throw new RuntimeException("Operation checkChangesSinceRevision() not supported by the GIT handler");
    }

    @Override
    public boolean checkChangesSinceDate(File moduleDirectory, Date date) {
        if (this.git == null) {
            return false;
        }
        try {
            RevCommit commit;
            Date commitTime;
            String modulePath = PathUtil.relativePath(this.baseDir, moduleDirectory);
            LogCommand logCommand = this.git.log().setMaxCount(100);
            if (!modulePath.isEmpty()) {
                logCommand.addPath(modulePath);
            }
            Iterator i$ = logCommand.call().iterator();
            while (i$.hasNext() && (commitTime = new Date((long)(commit = (RevCommit)i$.next()).getCommitTime() * 1000L)).after(date)) {
                if (commit.getFullMessage().startsWith("Nonsnapshot Plugin:")) continue;
                LOG.debug("Module folder {}: Change since last commit: rev{} @ {} ({})", new Object[]{moduleDirectory.getAbsolutePath(), commit.getId(), commitTime, commit.getFullMessage()});
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to check changes for path: {}" + moduleDirectory.getAbsolutePath(), (Throwable)e);
            return true;
        }
        return false;
    }

    @Override
    public String getNextRevisionId(File path) {
        throw new RuntimeException("Operation getNextRevisionId() not supported by the GIT handler");
    }

    @Override
    public void commitFiles(List<File> files, String commitMessage) {
        LOG.debug("Committing files: {}", files);
        try {
            for (File file : files) {
                String filePath = PathUtil.relativePath(this.baseDir, file);
                LOG.debug("Git: Adding file: {}", (Object)filePath);
                this.git.add().addFilepattern(filePath).call();
            }
            LOG.debug("Git: Committing changes");
            this.git.commit().setMessage(commitMessage).call();
            if (this.doPush) {
                LOG.debug("Git: Pushing changes");
                ((PushCommand)this.git.push().setCredentialsProvider(this.credentialsProvider)).call();
            }
        }
        catch (Exception e) {
            throw new NonSnapshotPluginException("Failed to commit files!", e);
        }
    }

    @Override
    public void init(File baseDir, String scmUser, String scmPassword, Properties properties) {
        this.baseDir = this.findGitRepo(baseDir);
        if (this.baseDir == null) {
            LOG.error("Project seems not be within a GIT repository!");
            return;
        }
        LOG.info("Using GIT repository: {}", (Object)this.baseDir.getAbsolutePath());
        try {
            FileRepository localRepo = new FileRepository(this.baseDir + "/.git");
            this.git = new Git((Repository)localRepo);
            if (scmPassword != null && !scmPassword.trim().isEmpty()) {
                this.credentialsProvider = new UsernamePasswordAndPassphraseCredentialProvider(scmUser, scmPassword);
            }
            if (properties != null && "false".equals(properties.getProperty("gitDoPush"))) {
                this.doPush = false;
                LOG.info("GIT push is disabled");
            }
        }
        catch (Exception e) {
            LOG.error("Project seems not be within a GIT repository!", (Throwable)e);
        }
    }

    private File findGitRepo(File baseDir) {
        File dir = baseDir;
        do {
            if (!new File(dir, ".git").exists()) continue;
            return dir;
        } while ((dir = dir.getParentFile()) != null);
        return null;
    }

    static {
        SshSessionFactory.setInstance((SshSessionFactory)new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host hc, Session session) {
                session.setConfig("StrictHostKeyChecking", "no");
            }
        });
    }

    private static class UsernamePasswordAndPassphraseCredentialProvider
    extends CredentialsProvider {
        private String username;
        private String password;

        private UsernamePasswordAndPassphraseCredentialProvider(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean supports(CredentialItem ... items) {
            return true;
        }

        public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
            for (CredentialItem i : items) {
                if (i instanceof CredentialItem.Username) {
                    ((CredentialItem.Username)i).setValue(this.username);
                    continue;
                }
                if (i instanceof CredentialItem.Password) {
                    ((CredentialItem.Password)i).setValue(this.password.toCharArray());
                    continue;
                }
                if (i instanceof CredentialItem.StringType && (i.getPromptText().equals("Password: ") || i.getPromptText().startsWith("Passphrase "))) {
                    ((CredentialItem.StringType)i).setValue(this.password);
                    continue;
                }
                throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
            }
            return true;
        }
    }
}

