/*
 * Decompiled with CFR 0.152.
 */
package at.nonblocking.maven.nonsnapshot;

import at.nonblocking.maven.nonsnapshot.NonSnapshotBaseMojo;
import at.nonblocking.maven.nonsnapshot.PathUtil;
import at.nonblocking.maven.nonsnapshot.ProcessedUpstreamDependency;
import at.nonblocking.maven.nonsnapshot.SCM_TYPE;
import at.nonblocking.maven.nonsnapshot.exception.NonSnapshotDependencyResolverException;
import at.nonblocking.maven.nonsnapshot.exception.NonSnapshotPluginException;
import at.nonblocking.maven.nonsnapshot.model.MavenArtifact;
import at.nonblocking.maven.nonsnapshot.model.MavenModule;
import at.nonblocking.maven.nonsnapshot.model.MavenModuleDependency;
import at.nonblocking.maven.nonsnapshot.model.UpdatedUpstreamMavenArtifact;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="updateVersions", aggregator=true)
public class NonSnapshotUpdateVersionsMojo
extends NonSnapshotBaseMojo {
    private static Logger LOG = LoggerFactory.getLogger(NonSnapshotUpdateVersionsMojo.class);
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private String timestamp;

    @Override
    protected void internalExecute() {
        this.setTimestamp();
        List<Model> mavenModels = this.getModuleTraverser().findAllModules(this.getMavenProject(), this.getMavenProject().getActiveProfiles());
        List<MavenModule> mavenModules = this.buildModules(mavenModels);
        MavenModule rootModule = mavenModules.get(0);
        this.getDependencyTreeProcessor().buildDependencyTree(mavenModules);
        this.markDirtyWhenRevisionChangedOrInvalidQualifier(mavenModules);
        if (this.getUpstreamDependencies() != null) {
            this.updateUpstreamArtifacts(mavenModules);
        }
        boolean changes = this.getDependencyTreeProcessor().markAllArtifactsDirtyWithDirtyDependencies(mavenModules);
        while (changes) {
            changes = this.getDependencyTreeProcessor().markAllArtifactsDirtyWithDirtyDependencies(mavenModules);
        }
        this.setNextRevisionOnDirtyArtifacts(mavenModules);
        this.dumpArtifactTreeToLog(rootModule);
        this.writeAndCommitArtifacts(mavenModules);
    }

    private List<MavenModule> buildModules(List<Model> mavenModels) {
        ArrayList<MavenModule> mavenModules = new ArrayList<MavenModule>();
        for (Model model : mavenModels) {
            MavenModule module = this.getMavenPomHandler().readArtifact(model);
            mavenModules.add(module);
        }
        return mavenModules;
    }

    protected void writeAndCommitArtifacts(List<MavenModule> mavenModules) {
        ArrayList<File> pomsToCommit = new ArrayList<File>();
        for (MavenModule mavenModule : mavenModules) {
            if (!mavenModule.isDirty() || mavenModule.getNewVersion() == null) continue;
            this.getMavenPomHandler().updateArtifact(mavenModule);
            LOG.debug("Add module to dirty registry list: {}", (Object)mavenModule.getPomFile().getAbsolutePath());
            pomsToCommit.add(mavenModule.getPomFile());
        }
        if (this.isGenerateChangedProjectsPropertyFile()) {
            this.generateChangedProjectsPropertyFile(pomsToCommit);
        }
        if (pomsToCommit.size() > 0) {
            this.writeDirtyModulesRegistry(pomsToCommit);
            if (this.isGenerateIncrementalBuildScripts()) {
                this.generateIncrementalBuildScripts(pomsToCommit);
            }
            if (!this.isDeferPomCommit()) {
                LOG.info("Committing {} POM files", (Object)pomsToCommit.size());
                this.getScmHandler().commitFiles(pomsToCommit, "Nonsnapshot Plugin: Version of " + pomsToCommit.size() + " artifacts updated");
            } else {
                LOG.info("Deferring the POM commit. Execute nonsnapshot:commit to actually commit the changes.");
            }
        } else {
            LOG.info("Modules are up-to-date. No versions updated.");
        }
    }

    private void markDirtyWhenRevisionChangedOrInvalidQualifier(List<MavenModule> mavenModules) {
        for (MavenModule mavenModule : mavenModules) {
            boolean changes;
            if (mavenModule.getVersion() == null) {
                LOG.info("No version found for artifact {}:{}. Assigning a new version.", (Object)mavenModule.getGroupId(), (Object)mavenModule.getArtifactId());
                mavenModule.setDirty(true);
                continue;
            }
            if (mavenModule.getVersion().startsWith("${")) {
                LOG.info("Version property found for artifact {}:{}. Assigning a new version.", (Object)mavenModule.getGroupId(), (Object)mavenModule.getArtifactId());
                mavenModule.setDirty(true);
                continue;
            }
            String[] versionParts = mavenModule.getVersion().split("-");
            String qualifierString = null;
            if (versionParts.length > 1) {
                qualifierString = versionParts[versionParts.length - 1];
            }
            if (qualifierString == null) {
                LOG.info("Invalid qualifier string found for artifact {}:{}: {}. Assigning a new version.", new Object[]{mavenModule.getGroupId(), mavenModule.getArtifactId(), mavenModule.getVersion()});
                mavenModule.setDirty(true);
                continue;
            }
            if (qualifierString.equals("SNAPSHOT")) {
                LOG.info("Snapshot version found for artifact {}:{}. Assigning a new version.", (Object)mavenModule.getGroupId(), (Object)mavenModule.getArtifactId());
                mavenModule.setDirty(true);
                continue;
            }
            if (this.getScmType() == SCM_TYPE.SVN && this.isUseSvnRevisionQualifier()) {
                changes = this.getScmHandler().checkChangesSinceRevision(mavenModule.getPomFile().getParentFile(), qualifierString);
                if (!changes) continue;
                LOG.info("Module {}:{}: Revision number is different from the revision number in the version qualifier. Assigning a new version.", (Object)mavenModule.getGroupId(), (Object)mavenModule.getArtifactId());
                mavenModule.setDirty(true);
                continue;
            }
            try {
                Date versionTimestamp = new SimpleDateFormat(this.getTimestampQualifierPattern()).parse(qualifierString);
                changes = this.getScmHandler().checkChangesSinceDate(mavenModule.getPomFile().getParentFile(), versionTimestamp);
            }
            catch (ParseException e) {
                LOG.debug("Module {}:{}: Invalid timestamp qualifier: {}", new Object[]{mavenModule.getGroupId(), mavenModule.getArtifactId(), qualifierString});
                changes = true;
            }
            if (!changes) continue;
            LOG.info("Module {}:{}: There were commits after the timestamp in the version qualifier. Assigning a new version.", (Object)mavenModule.getGroupId(), (Object)mavenModule.getArtifactId());
            mavenModule.setDirty(true);
        }
    }

    private void updateUpstreamArtifacts(List<MavenModule> mavenModules) {
        for (MavenModule mavenModule : mavenModules) {
            UpdatedUpstreamMavenArtifact updatedUpstreamMavenArtifactParent;
            if (mavenModule.getParent() != null && (updatedUpstreamMavenArtifactParent = this.updateUpstreamArtifact(mavenModule.getParent())) != null) {
                mavenModule.setParent(updatedUpstreamMavenArtifactParent);
            }
            for (MavenModuleDependency moduleDependency : mavenModule.getDependencies()) {
                UpdatedUpstreamMavenArtifact updatedUpstreamMavenArtifactDep = this.updateUpstreamArtifact(moduleDependency.getArtifact());
                if (updatedUpstreamMavenArtifactDep == null) continue;
                moduleDependency.setArtifact(updatedUpstreamMavenArtifactDep);
            }
        }
    }

    private UpdatedUpstreamMavenArtifact updateUpstreamArtifact(MavenArtifact upstreamArtifact) {
        ProcessedUpstreamDependency upstreamDependency;
        if (!(upstreamArtifact instanceof MavenModule) && (upstreamDependency = this.getUpstreamDependencyHandler().findMatch(upstreamArtifact, this.getProcessedUpstreamDependencies())) != null) {
            LOG.debug("Upstream dependency found: {}:{}", (Object)upstreamArtifact.getGroupId(), (Object)upstreamArtifact.getArtifactId());
            try {
                String latestVersion = this.getUpstreamDependencyHandler().resolveLatestVersion(upstreamArtifact, upstreamDependency, this.getRepositorySystem(), this.getRepositorySystemSession(), this.getRemoteRepositories());
                if (latestVersion != null) {
                    LOG.info("Found newer version for upstream dependency {}:{}: {}", new Object[]{upstreamArtifact.getGroupId(), upstreamArtifact.getArtifactId(), latestVersion});
                    return new UpdatedUpstreamMavenArtifact(upstreamArtifact.getGroupId(), upstreamArtifact.getArtifactId(), upstreamArtifact.getVersion(), latestVersion);
                }
            }
            catch (NonSnapshotDependencyResolverException e) {
                if (this.isDontFailOnUpstreamVersionResolution()) {
                    LOG.warn("Upstream dependency resolution failed (cannot update {}:{}). Error: {}", new Object[]{upstreamArtifact.getGroupId(), upstreamArtifact.getArtifactId(), e.getMessage()});
                }
                throw e;
            }
        }
        return null;
    }

    private void setNextRevisionOnDirtyArtifacts(List<MavenModule> mavenModules) {
        for (MavenModule mavenModule : mavenModules) {
            File modulesPath;
            try {
                modulesPath = mavenModule.getPomFile().getParentFile().getCanonicalFile();
            }
            catch (IOException e) {
                throw new NonSnapshotPluginException("Unexpected IO exception", e);
            }
            if (!mavenModule.isDirty()) continue;
            if (!this.getScmHandler().isWorkingCopy(modulesPath)) {
                throw new NonSnapshotPluginException("Module path is no working directory: " + modulesPath);
            }
            if (this.isUseSvnRevisionQualifier()) {
                mavenModule.setNewVersion(this.getBaseVersion() + "-" + this.getScmHandler().getNextRevisionId(modulesPath));
                continue;
            }
            mavenModule.setNewVersion(this.getBaseVersion() + "-" + this.timestamp);
        }
    }

    private void writeDirtyModulesRegistry(List<File> pomFileList) {
        File dirtyModulesRegistryFile = this.getDirtyModulesRegistryFile();
        LOG.info("Writing dirty modules registry to: {}", (Object)dirtyModulesRegistryFile.getAbsolutePath());
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(dirtyModulesRegistryFile, false));){
            for (File pomFile : pomFileList) {
                String relativeModuleDir = PathUtil.relativePath(this.getMavenProject().getBasedir(), pomFile.getParentFile());
                if (relativeModuleDir.isEmpty()) {
                    relativeModuleDir = ".";
                }
                writer.write(relativeModuleDir + LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            throw new NonSnapshotPluginException("Failed to write text file with POMs to commit!", e);
        }
    }

    private void generateIncrementalBuildScripts(List<File> pomFileList) {
        String projectPaths = this.createProjectPathsString(pomFileList);
        if (this.isWindows()) {
            File batFile = new File(this.getMavenProject().getBasedir(), "nonsnapshotBuildIncremental.bat");
            LOG.info("Writing windows batch script for incremental build to: {}", (Object)batFile.getAbsolutePath());
            try (PrintWriter writer = new PrintWriter(batFile);){
                writer.write("@ECHO OFF\n");
                writer.write("REM Incremental build script generated by nonsnapshot-maven-plugin\n");
                writer.write("REM To install all modified modules call:\n");
                writer.write("REM nonsnapshotBuildIncremental.bat install\n\n");
                writer.write("SET MVN_EXEC=mvn.bat\n");
                writer.write("IF DEFINED M2_HOME (set MVN_EXEC=%M2_HOME%\\bin\\mvn.bat)\n");
                writer.write("ECHO Using maven executable: %MVN_EXEC%\n");
                writer.write("%MVN_EXEC% --projects " + projectPaths + " %*");
                writer.close();
            }
            catch (IOException e) {
                LOG.error("Failed to write windows batch script for incremental build!", (Throwable)e);
            }
        } else {
            File shellFile = new File(this.getMavenProject().getBasedir(), "nonsnapshotBuildIncremental.sh");
            LOG.info("Writing unix shell script for incremental build to: {}", (Object)shellFile.getAbsolutePath());
            try (PrintWriter writer = new PrintWriter(shellFile);){
                writer.write("#!/bin/sh\n");
                writer.write("# Incremental build script generated by nonsnapshot-maven-plugin\n");
                writer.write("# To install all modified modules call:\n");
                writer.write("# ./nonsnapshotBuildIncremental.sh install\n\n");
                writer.write("MVN_EXEC=mvn\n");
                writer.write("if [ ! -z \"$M2_HOME\" ]; then\n");
                writer.write("  MVN_EXEC=$M2_HOME/bin/mvn\n");
                writer.write("fi\n");
                writer.write("echo \"Using maven executable: $MVN_EXEC\"\n");
                writer.write("$MVN_EXEC --projects " + projectPaths + " $@");
                writer.close();
                Runtime.getRuntime().exec("chmod u+x " + shellFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error("Failed to write windows batch script for incremental build!", (Throwable)e);
            }
        }
    }

    private void generateChangedProjectsPropertyFile(List<File> pomFileList) {
        String projectPaths = this.createProjectPathsString(pomFileList);
        if (projectPaths.isEmpty()) {
            projectPaths = ".";
        }
        File propertyFile = new File(this.getMavenProject().getBasedir(), "nonsnapshotChangedProjects.properties");
        LOG.info("Writing changed projects to property file: {}", (Object)propertyFile.getAbsolutePath());
        try (PrintWriter writer = new PrintWriter(propertyFile);){
            writer.write("#Property with changed projects generated by nonsnapshot-maven-plugin\n");
            writer.write("#Can be used together with the Jenkins EnvInject plugin to build changed projects only:\n");
            writer.write("#mvn --projects ${nonsnapshot.changed.projects} install\n");
            writer.write("nonsnapshot.changed.projects=" + projectPaths + "\n");
            writer.close();
        }
        catch (IOException e) {
            LOG.error("Failed to write changed projects property file!", (Throwable)e);
        }
    }

    private String createProjectPathsString(List<File> pomFileList) {
        StringBuilder projectPaths = new StringBuilder();
        try {
            for (File pomFile : pomFileList) {
                String relativeModuleDir = PathUtil.relativePath(this.getMavenProject().getBasedir(), pomFile.getParentFile());
                if (relativeModuleDir.isEmpty()) {
                    relativeModuleDir = ".";
                }
                if (projectPaths.length() != 0) {
                    relativeModuleDir = "," + relativeModuleDir;
                }
                projectPaths.append(relativeModuleDir);
            }
            return projectPaths.toString();
        }
        catch (IOException e) {
            throw new NonSnapshotPluginException("Failed determine changed project paths!", e);
        }
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private void setTimestamp() {
        this.timestamp = new SimpleDateFormat(this.getTimestampQualifierPattern()).format(new Date());
    }

    private void dumpArtifactTreeToLog(MavenModule rootModule) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getDependencyTreeProcessor().printMavenModuleTree(rootModule, new PrintStream(baos));
        LOG.info("\n" + baos.toString());
    }
}

