/*
 * Copyright 2012-2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package at.nonblocking.maven.nonsnapshot.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * Represents an (updated) upstream artifact; so dirty will always return true.
 * 
 * @author Juergen Kofler
 */
public class UpdatedUpstreamMavenArtifact extends MavenArtifact {

    private String newVersion;
    private boolean dirty;

    public UpdatedUpstreamMavenArtifact(String groupId, String artifactId, String currentVersion, String newVersion) {
        super(groupId, artifactId, currentVersion);
        this.newVersion = newVersion;
        this.dirty = true;
    }

    public boolean isDirty() {
        return dirty;
    }

    public String getNewVersion() {
        return newVersion;
    }
}
