/*
 * Decompiled with CFR 0.152.
 */
package at.nonblocking.maven.nonsnapshot;

import at.nonblocking.maven.nonsnapshot.NonSnapshotBaseMojo;
import at.nonblocking.maven.nonsnapshot.exception.NonSnapshotPluginException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="commitVersions", aggregator=true)
public class NonSnapshotCommitMojo
extends NonSnapshotBaseMojo {
    private static Logger LOG = LoggerFactory.getLogger(NonSnapshotCommitMojo.class);

    @Override
    protected void internalExecute() {
        File dirtyModulesRegistryFile = this.getDirtyModulesRegistryFile();
        LOG.debug("Reading POM files to commit from: {}", (Object)dirtyModulesRegistryFile.getAbsolutePath());
        if (!dirtyModulesRegistryFile.exists()) {
            LOG.info("File {} does not exist. Doing nothing.", (Object)dirtyModulesRegistryFile.getAbsolutePath());
            return;
        }
        List<File> pomsToCommit = this.readPomFileList(dirtyModulesRegistryFile);
        if (pomsToCommit.size() == 0) {
            return;
        }
        try {
            LOG.info("Committing {} POM files", (Object)pomsToCommit.size());
            this.getScmHandler().commitFiles(pomsToCommit, "Nonsnapshot Plugin: Version of " + pomsToCommit.size() + " modules updated");
        }
        catch (RuntimeException e) {
            if (this.isDontFailOnCommit()) {
                LOG.warn("Error occurred during commit, ignoring it since dontFailOnCommit=true.", (Throwable)e);
            }
            throw e;
        }
    }

    private List<File> readPomFileList(File inputFile) {
        ArrayList<File> pomFileList = new ArrayList<File>();
        File baseDir = this.getMavenProject().getBasedir();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(inputFile));
            while ((line = reader.readLine()) != null) {
                File pom = new File(baseDir, line + "/pom.xml").getCanonicalFile();
                if (pomFileList.contains(pom)) continue;
                pomFileList.add(pom);
            }
            reader.close();
            LOG.info("Deleting dirty modules registry file: {}", (Object)inputFile.getAbsolutePath());
            inputFile.delete();
            return pomFileList;
        }
        catch (IOException e) {
            throw new NonSnapshotPluginException("Failed to read dirty modules registry file!", e);
        }
    }
}

