/*
 * Decompiled with CFR 0.152.
 */
package at.nonblocking.maven.nonsnapshot;

import at.nonblocking.maven.nonsnapshot.DependencyTreeProcessor;
import at.nonblocking.maven.nonsnapshot.MavenPomHandler;
import at.nonblocking.maven.nonsnapshot.ModuleTraverser;
import at.nonblocking.maven.nonsnapshot.ProcessedUpstreamDependency;
import at.nonblocking.maven.nonsnapshot.SCM_TYPE;
import at.nonblocking.maven.nonsnapshot.ScmHandler;
import at.nonblocking.maven.nonsnapshot.UpstreamDependencyHandler;
import at.nonblocking.maven.nonsnapshot.exception.NonSnapshotPluginException;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

abstract class NonSnapshotBaseMojo
extends AbstractMojo
implements Contextualizable {
    private static final Logger LOG = LoggerFactory.getLogger(NonSnapshotBaseMojo.class);
    private static final String DEFAULT_TIMESTAMP_QUALIFIER_PATTERN = "yyyyMMddHHmm";
    protected static final String DIRTY_MODULES_REGISTRY_FILE = "nonSnapshotDirtyModules.txt";
    @Parameter(defaultValue="SVN")
    private SCM_TYPE scmType;
    @Parameter
    private String scmUser;
    @Parameter
    private String scmPassword;
    @Parameter(defaultValue="true")
    private boolean gitDoPush;
    @Parameter(defaultValue="false")
    private boolean deferPomCommit;
    @Parameter(defaultValue="false")
    private boolean dontFailOnUpstreamVersionResolution;
    @Parameter(defaultValue="false")
    private boolean dontFailOnCommit;
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(required=true)
    private String baseVersion;
    @Parameter(defaultValue="false")
    private boolean useSvnRevisionQualifier;
    @Parameter(defaultValue="yyyyMMddHHmm")
    private String timestampQualifierPattern = "yyyyMMddHHmm";
    @Parameter
    private List<String> upstreamDependencies;
    @Parameter(defaultValue="false")
    private boolean generateIncrementalBuildScripts;
    @Parameter(defaultValue="false")
    private boolean generateChangedProjectsPropertyFile;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Component(role=MavenPomHandler.class, hint="default")
    private MavenPomHandler mavenPomHandler;
    @Component(role=ModuleTraverser.class, hint="default")
    private ModuleTraverser moduleTraverser;
    @Component(role=DependencyTreeProcessor.class, hint="default")
    private DependencyTreeProcessor dependencyTreeProcessor;
    @Component(role=UpstreamDependencyHandler.class, hint="default")
    private UpstreamDependencyHandler upstreamDependencyHandler;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}")
    private List<RemoteRepository> remoteRepositories;
    private List<ProcessedUpstreamDependency> processedUpstreamDependencies;
    private ScmHandler scmHandler;
    private PlexusContainer plexusContainer;

    NonSnapshotBaseMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setLog(this.getLog());
        if (this.skip) {
            LOG.info("NonSnapshot Plugin has been disabled for this project.");
            return;
        }
        LOG.info("Executing NonSnapshot Plugin for project path: {}", (Object)this.mavenProject.getBasedir().getAbsolutePath());
        this.postProcessParameters();
        this.internalExecute();
    }

    protected abstract void internalExecute();

    private void postProcessParameters() {
        if (this.scmHandler == null) {
            LOG.debug("Lookup for ScmHandler implementation of type: {}", (Object)this.scmType);
            try {
                this.scmHandler = (ScmHandler)this.plexusContainer.lookup(ScmHandler.class, this.scmType.name());
            }
            catch (ComponentLookupException e) {
                throw new NonSnapshotPluginException("Unable to instantiate ScmHandler class for type: " + (Object)((Object)this.scmType), e);
            }
            if (this.scmHandler == null) {
                throw new NonSnapshotPluginException("Unable to instantiate ScmHandler class for type: " + (Object)((Object)this.scmType));
            }
            LOG.debug("Found ScmHandler: {}", this.scmHandler.getClass());
        }
        Properties properties = new Properties();
        properties.setProperty("gitDoPush", String.valueOf(this.gitDoPush));
        this.scmHandler.init(this.getMavenProject().getBasedir(), this.scmUser, this.scmPassword, properties);
        this.processedUpstreamDependencies = this.upstreamDependencyHandler.processDependencyList(this.getUpstreamDependencies());
    }

    protected File getDirtyModulesRegistryFile() {
        return new File(this.mavenProject.getBasedir(), DIRTY_MODULES_REGISTRY_FILE);
    }

    public void contextualize(Context context) throws ContextException {
        this.plexusContainer = (PlexusContainer)context.get((Object)"plexus");
    }

    public SCM_TYPE getScmType() {
        return this.scmType;
    }

    public void setScmType(SCM_TYPE scmType) {
        this.scmType = scmType;
    }

    public String getScmUser() {
        return this.scmUser;
    }

    public void setScmUser(String scmUser) {
        this.scmUser = scmUser;
    }

    public String getScmPassword() {
        return this.scmPassword;
    }

    public void setScmPassword(String scmPassword) {
        this.scmPassword = scmPassword;
    }

    public boolean isGitDoPush() {
        return this.gitDoPush;
    }

    public void setGitDoPush(boolean gitDoPush) {
        this.gitDoPush = gitDoPush;
    }

    public boolean isDeferPomCommit() {
        return this.deferPomCommit;
    }

    public void setDeferPomCommit(boolean deferPomCommit) {
        this.deferPomCommit = deferPomCommit;
    }

    public boolean isDontFailOnUpstreamVersionResolution() {
        return this.dontFailOnUpstreamVersionResolution;
    }

    public void setDontFailOnUpstreamVersionResolution(boolean dontFailOnUpstreamVersionResolution) {
        this.dontFailOnUpstreamVersionResolution = dontFailOnUpstreamVersionResolution;
    }

    public boolean isDontFailOnCommit() {
        return this.dontFailOnCommit;
    }

    public void setDontFailOnCommit(boolean dontFailOnCommit) {
        this.dontFailOnCommit = dontFailOnCommit;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public void setBaseVersion(String baseVersion) {
        this.baseVersion = baseVersion;
    }

    public boolean isUseSvnRevisionQualifier() {
        return this.useSvnRevisionQualifier;
    }

    public void setUseSvnRevisionQualifier(boolean useSvnRevisionQualifier) {
        this.useSvnRevisionQualifier = useSvnRevisionQualifier;
    }

    public String getTimestampQualifierPattern() {
        return this.timestampQualifierPattern;
    }

    public void setTimestampQualifierPattern(String timestampQualifierPattern) {
        this.timestampQualifierPattern = timestampQualifierPattern;
    }

    public List<String> getUpstreamDependencies() {
        return this.upstreamDependencies;
    }

    public void setUpstreamDependencies(List<String> upstreamDependencies) {
        this.upstreamDependencies = upstreamDependencies;
    }

    public boolean isGenerateIncrementalBuildScripts() {
        return this.generateIncrementalBuildScripts;
    }

    public void setGenerateIncrementalBuildScripts(boolean generateIncrementalBuildScripts) {
        this.generateIncrementalBuildScripts = generateIncrementalBuildScripts;
    }

    public boolean isGenerateChangedProjectsPropertyFile() {
        return this.generateChangedProjectsPropertyFile;
    }

    public void setGenerateChangedProjectsPropertyFile(boolean generateChangedProjectsPropertyFile) {
        this.generateChangedProjectsPropertyFile = generateChangedProjectsPropertyFile;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public MavenPomHandler getMavenPomHandler() {
        return this.mavenPomHandler;
    }

    public void setMavenPomHandler(MavenPomHandler mavenPomHandler) {
        this.mavenPomHandler = mavenPomHandler;
    }

    public ModuleTraverser getModuleTraverser() {
        return this.moduleTraverser;
    }

    public void setModuleTraverser(ModuleTraverser moduleTraverser) {
        this.moduleTraverser = moduleTraverser;
    }

    public DependencyTreeProcessor getDependencyTreeProcessor() {
        return this.dependencyTreeProcessor;
    }

    public void setDependencyTreeProcessor(DependencyTreeProcessor dependencyTreeProcessor) {
        this.dependencyTreeProcessor = dependencyTreeProcessor;
    }

    public UpstreamDependencyHandler getUpstreamDependencyHandler() {
        return this.upstreamDependencyHandler;
    }

    public void setUpstreamDependencyHandler(UpstreamDependencyHandler upstreamDependencyHandler) {
        this.upstreamDependencyHandler = upstreamDependencyHandler;
    }

    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public void setRepositorySystem(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    public RepositorySystemSession getRepositorySystemSession() {
        return this.repositorySystemSession;
    }

    public void setRepositorySystemSession(RepositorySystemSession repositorySystemSession) {
        this.repositorySystemSession = repositorySystemSession;
    }

    public List<RemoteRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List<RemoteRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public List<ProcessedUpstreamDependency> getProcessedUpstreamDependencies() {
        return this.processedUpstreamDependencies;
    }

    public void setProcessedUpstreamDependencies(List<ProcessedUpstreamDependency> processedUpstreamDependencies) {
        this.processedUpstreamDependencies = processedUpstreamDependencies;
    }

    public ScmHandler getScmHandler() {
        return this.scmHandler;
    }

    public void setScmHandler(ScmHandler scmHandler) {
        this.scmHandler = scmHandler;
    }

    public PlexusContainer getPlexusContainer() {
        return this.plexusContainer;
    }

    public void setPlexusContainer(PlexusContainer plexusContainer) {
        this.plexusContainer = plexusContainer;
    }
}

