/*
 * Decompiled with CFR 0.152.
 */
package at.mukprojects.giphy4j.dao;

import at.mukprojects.giphy4j.dao.RequestSender;
import at.mukprojects.giphy4j.http.Request;
import at.mukprojects.giphy4j.http.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

public class HttpRequestSender
implements RequestSender {
    @Override
    public Response sendRequest(Request request) throws IOException {
        HttpURLConnection connection = this.createConnection(request);
        Response response = this.send(connection);
        return response;
    }

    private HttpURLConnection createConnection(Request request) throws IOException {
        URL url = new URL(request.getUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        connection.setRequestMethod("GET");
        return connection;
    }

    private Response send(HttpURLConnection connection) throws IOException {
        connection.connect();
        if (connection.getResponseCode() != 200) {
            throw new IOException("Bad response! Code: " + connection.getResponseCode());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String key : connection.getHeaderFields().keySet()) {
            headers.put(key, connection.getHeaderFields().get(key).get(0));
        }
        String body = null;
        try (InputStream inputStream = null;){
            inputStream = connection.getInputStream();
            String encoding = connection.getContentEncoding();
            encoding = encoding == null ? "UTF-8" : encoding;
            body = IOUtils.toString((InputStream)inputStream, (String)encoding);
        }
        if (body == null) {
            throw new IOException("Unparseable response body! \n {" + body + "}");
        }
        Response response = new Response(headers, body);
        return response;
    }
}

