/*
 * Decompiled with CFR 0.152.
 */
package at.mukprojects.giphy4j;

import at.mukprojects.giphy4j.dao.HttpRequestSender;
import at.mukprojects.giphy4j.dao.RequestSender;
import at.mukprojects.giphy4j.entity.search.SearchFeed;
import at.mukprojects.giphy4j.entity.search.SearchGiphy;
import at.mukprojects.giphy4j.entity.search.SearchRandom;
import at.mukprojects.giphy4j.exception.GiphyException;
import at.mukprojects.giphy4j.http.Request;
import at.mukprojects.giphy4j.http.Response;
import at.mukprojects.giphy4j.util.UrlUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Giphy {
    private static final Logger log = LoggerFactory.getLogger(Giphy.class);
    private static final String SearchEndpoint = "http://api.giphy.com/v1/gifs/search";
    private static final String IDEndpoint = "http://api.giphy.com/v1/gifs/";
    private static final String TranslateEndpoint = "http://api.giphy.com/v1/gifs/translate";
    private static final String RandomEndpoint = "http://api.giphy.com/v1/gifs/random";
    private static final String TrendingEndpoint = "http://api.giphy.com/v1/gifs/trending";
    private static final String SearchStickerEndpoint = "http://api.giphy.com/v1/stickers/search";
    private static final String TranslateStickerEndpoint = "http://api.giphy.com/v1/stickers/translate";
    private static final String RandomEndpointSticker = "http://api.giphy.com/v1/stickers/random";
    private static final String TrendingStickerEndpoint = "http://api.giphy.com/v1/stickers/trending";
    private String apiKey;
    private RequestSender sender;
    private Gson gson;

    public Giphy(String apiKey) {
        this.apiKey = apiKey;
        this.sender = new HttpRequestSender();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public Giphy(String apiKey, RequestSender sender) {
        this.apiKey = apiKey;
        this.sender = sender;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public SearchFeed search(String query, int offset) throws GiphyException {
        return this.search(query, 25, offset);
    }

    public SearchFeed search(String query, int limit, int offset) throws GiphyException {
        SearchFeed feed = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        params.put("q", query);
        if (limit > 100) {
            params.put("limit", "100");
        } else {
            params.put("limit", limit + "");
        }
        params.put("offset", offset + "");
        Request request = new Request(UrlUtil.buildUrlQuery(SearchEndpoint, params));
        try {
            Response response = this.sender.sendRequest(request);
            feed = (SearchFeed)this.gson.fromJson(response.getBody(), SearchFeed.class);
        }
        catch (JsonSyntaxException | IOException e) {
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return feed;
    }

    public SearchGiphy searchByID(String id) throws GiphyException {
        SearchGiphy giphy = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        Request request = new Request(UrlUtil.buildUrlQuery(IDEndpoint + id, params));
        try {
            Response response = this.sender.sendRequest(request);
            giphy = (SearchGiphy)this.gson.fromJson(response.getBody(), SearchGiphy.class);
        }
        catch (JsonSyntaxException | IOException e) {
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return giphy;
    }

    public SearchGiphy translate(String query) throws GiphyException {
        SearchGiphy giphy = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        params.put("s", query);
        Request request = new Request(UrlUtil.buildUrlQuery(TranslateEndpoint, params));
        try {
            Response response = this.sender.sendRequest(request);
            giphy = (SearchGiphy)this.gson.fromJson(response.getBody(), SearchGiphy.class);
        }
        catch (JsonSyntaxException | IOException e) {
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return giphy;
    }

    public SearchRandom searchRandom(String tag) throws GiphyException {
        SearchRandom random = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        params.put("tag", tag);
        Request request = new Request(UrlUtil.buildUrlQuery(RandomEndpoint, params));
        try {
            Response response = this.sender.sendRequest(request);
            random = (SearchRandom)this.gson.fromJson(response.getBody(), SearchRandom.class);
        }
        catch (JsonSyntaxException | IOException e) {
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return random;
    }

    public SearchFeed trend() throws GiphyException {
        SearchFeed feed = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        Request request = new Request(UrlUtil.buildUrlQuery(TrendingEndpoint, params));
        try {
            Response response = this.sender.sendRequest(request);
            feed = (SearchFeed)this.gson.fromJson(response.getBody(), SearchFeed.class);
        }
        catch (JsonSyntaxException | IOException e) {
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return feed;
    }

    public SearchFeed searchSticker(String query, int offset) throws GiphyException {
        return this.searchSticker(query, 25, offset);
    }

    public SearchFeed searchSticker(String query, int limit, int offset) throws GiphyException {
        SearchFeed feed = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        params.put("q", query);
        if (limit > 100) {
            params.put("limit", "100");
        } else {
            params.put("limit", limit + "");
        }
        params.put("offset", offset + "");
        Request request = new Request(UrlUtil.buildUrlQuery(SearchStickerEndpoint, params));
        try {
            Response response = this.sender.sendRequest(request);
            feed = (SearchFeed)this.gson.fromJson(response.getBody(), SearchFeed.class);
        }
        catch (JsonSyntaxException | IOException e) {
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return feed;
    }

    public SearchGiphy translateSticker(String query) throws GiphyException {
        SearchGiphy giphy = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        params.put("s", query);
        Request request = new Request(UrlUtil.buildUrlQuery(TranslateStickerEndpoint, params));
        try {
            Response response = this.sender.sendRequest(request);
            giphy = (SearchGiphy)this.gson.fromJson(response.getBody(), SearchGiphy.class);
        }
        catch (JsonSyntaxException | IOException e) {
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return giphy;
    }

    public SearchFeed trendSticker() throws GiphyException {
        SearchFeed feed = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        Request request = new Request(UrlUtil.buildUrlQuery(TrendingStickerEndpoint, params));
        try {
            Response response = this.sender.sendRequest(request);
            feed = (SearchFeed)this.gson.fromJson(response.getBody(), SearchFeed.class);
        }
        catch (JsonSyntaxException | IOException e) {
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return feed;
    }

    public SearchRandom searchRandomSticker(String tag) throws GiphyException {
        SearchRandom random = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        params.put("tag", tag);
        Request request = new Request(UrlUtil.buildUrlQuery(RandomEndpointSticker, params));
        try {
            Response response = this.sender.sendRequest(request);
            random = (SearchRandom)this.gson.fromJson(response.getBody(), SearchRandom.class);
        }
        catch (JsonSyntaxException | IOException e) {
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return random;
    }
}

