/*
 * Decompiled with CFR 0.152.
 */
package at.mukprojects.giphy4j;

import at.mukprojects.giphy4j.entity.search.SearchFeed;
import at.mukprojects.giphy4j.entity.search.SerachGiphy;
import at.mukprojects.giphy4j.exception.GiphyException;
import at.mukprojects.giphy4j.http.HttpUtil;
import at.mukprojects.giphy4j.http.UrlUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Giphy {
    private static final Logger log = LoggerFactory.getLogger(Giphy.class);
    private static final String SearchEndpoint = "http://api.giphy.com/v1/gifs/search";
    private static final String IDEndpoint = "http://api.giphy.com/v1/gifs/";
    private static final String TranslateEndpoint = "http://api.giphy.com/v1/gifs/translate";
    private static final String TrendingEndpoint = "http://api.giphy.com/v1/gifs/trending";
    private static final String SearchStickerEndpoint = "http://api.giphy.com/v1/stickers/search";
    private static final String TranslateStickerEndpoint = "http://api.giphy.com/v1/stickers/translate";
    private static final String TrendingStickerEndpoint = "http://api.giphy.com/v1/stickers/trending";
    private String apiKey;
    private Gson gson;

    public Giphy(String apiKey) {
        this.apiKey = apiKey;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public SearchFeed search(String query, int offset) throws GiphyException {
        return this.search(query, 25, offset);
    }

    public SearchFeed search(String query, int limit, int offset) throws GiphyException {
        SearchFeed feed = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        params.put("q", query);
        if (limit > 100) {
            params.put("limit", "100");
        } else {
            params.put("limit", limit + "");
        }
        params.put("offset", offset + "");
        String url = UrlUtil.buildUrlQuery(SearchEndpoint, params);
        try {
            feed = (SearchFeed)this.gson.fromJson(HttpUtil.sendRequest(url), SearchFeed.class);
        }
        catch (JsonSyntaxException | IOException e) {
            try {
                log.debug(url);
                log.debug(HttpUtil.sendRequest(url));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return feed;
    }

    public SerachGiphy searchByID(String id) throws GiphyException {
        SerachGiphy giphy = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        String url = UrlUtil.buildUrlQuery(IDEndpoint + id, params);
        try {
            giphy = (SerachGiphy)this.gson.fromJson(HttpUtil.sendRequest(url), SerachGiphy.class);
        }
        catch (JsonSyntaxException | IOException e) {
            try {
                log.debug(url);
                log.debug(HttpUtil.sendRequest(url));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return giphy;
    }

    public SerachGiphy translate(String query) throws GiphyException {
        SerachGiphy giphy = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        params.put("s", query);
        String url = UrlUtil.buildUrlQuery(TranslateEndpoint, params);
        try {
            giphy = (SerachGiphy)this.gson.fromJson(HttpUtil.sendRequest(url), SerachGiphy.class);
        }
        catch (JsonSyntaxException | IOException e) {
            try {
                log.debug(url);
                log.debug(HttpUtil.sendRequest(url));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return giphy;
    }

    public SearchFeed trend() throws GiphyException {
        SearchFeed feed = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        String url = UrlUtil.buildUrlQuery(TrendingEndpoint, params);
        try {
            feed = (SearchFeed)this.gson.fromJson(HttpUtil.sendRequest(url), SearchFeed.class);
        }
        catch (JsonSyntaxException | IOException e) {
            try {
                log.debug(url);
                log.debug(HttpUtil.sendRequest(url));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return feed;
    }

    public SearchFeed searchSticker(String query, int offset) throws GiphyException {
        return this.searchSticker(query, 25, offset);
    }

    public SearchFeed searchSticker(String query, int limit, int offset) throws GiphyException {
        SearchFeed feed = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        params.put("q", query);
        if (limit > 100) {
            params.put("limit", "100");
        } else {
            params.put("limit", limit + "");
        }
        params.put("offset", offset + "");
        String url = UrlUtil.buildUrlQuery(SearchStickerEndpoint, params);
        try {
            feed = (SearchFeed)this.gson.fromJson(HttpUtil.sendRequest(url), SearchFeed.class);
        }
        catch (JsonSyntaxException | IOException e) {
            try {
                log.debug(url);
                log.debug(HttpUtil.sendRequest(url));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return feed;
    }

    public SerachGiphy translateSticker(String query) throws GiphyException {
        SerachGiphy giphy = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        params.put("s", query);
        String url = UrlUtil.buildUrlQuery(TranslateStickerEndpoint, params);
        try {
            giphy = (SerachGiphy)this.gson.fromJson(HttpUtil.sendRequest(url), SerachGiphy.class);
        }
        catch (JsonSyntaxException | IOException e) {
            try {
                log.debug(url);
                log.debug(HttpUtil.sendRequest(url));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return giphy;
    }

    public SearchFeed trendSticker() throws GiphyException {
        SearchFeed feed = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        String url = UrlUtil.buildUrlQuery(TrendingStickerEndpoint, params);
        try {
            feed = (SearchFeed)this.gson.fromJson(HttpUtil.sendRequest(url), SearchFeed.class);
        }
        catch (JsonSyntaxException | IOException e) {
            try {
                log.debug(url);
                log.debug(HttpUtil.sendRequest(url));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.error(e.getMessage(), e);
            throw new GiphyException(e);
        }
        return feed;
    }
}

